<?php

namespace fk_\EnumType;

/**
 * This class stands for HizmetHesapTipi EnumType
 * @subpackage Enumerations
 */
class HizmetHesapTipi
{
    /**
     * Constant for value 'Alinan'
     * @return string 'Alinan'
     */
    const VALUE_ALINAN = 'Alinan';
    /**
     * Constant for value 'Verilen'
     * @return string 'Verilen'
     */
    const VALUE_VERILEN = 'Verilen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALINAN
     * @uses self::VALUE_VERILEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALINAN,
            self::VALUE_VERILEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
