<?php

namespace fk_\EnumType;

/**
 * This class stands for CariKaraListeTipi EnumType
 * @subpackage Enumerations
 */
class CariKaraListeTipi
{
    /**
     * Constant for value 'KendindenKara'
     * @return string 'KendindenKara'
     */
    const VALUE_KENDINDEN_KARA = 'KendindenKara';
    /**
     * Constant for value 'UstCarisindenKara'
     * @return string 'UstCarisindenKara'
     */
    const VALUE_UST_CARISINDEN_KARA = 'UstCarisindenKara';
    /**
     * Constant for value 'KonsolidedenKara'
     * @return string 'KonsolidedenKara'
     */
    const VALUE_KONSOLIDEDEN_KARA = 'KonsolidedenKara';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KENDINDEN_KARA
     * @uses self::VALUE_UST_CARISINDEN_KARA
     * @uses self::VALUE_KONSOLIDEDEN_KARA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KENDINDEN_KARA,
            self::VALUE_UST_CARISINDEN_KARA,
            self::VALUE_KONSOLIDEDEN_KARA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
