<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankaSubesi StructType
 * @subpackage Structs
 */
class BankaSubesi extends SerendipEntity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Bankasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\BankaPointer
     */
    public $Bankasi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\Adres
     */
    public $Adresi;
    /**
     * The IletisimBilgileri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\Iletisim
     */
    public $IletisimBilgileri;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * Constructor method for BankaSubesi
     * @uses BankaSubesi::setAciklama()
     * @uses BankaSubesi::setBankasi()
     * @uses BankaSubesi::setAdresi()
     * @uses BankaSubesi::setIletisimBilgileri()
     * @uses BankaSubesi::setKodu()
     * @uses BankaSubesi::setAdi()
     * @param string $aciklama
     * @param \fk_\StructType\BankaPointer $bankasi
     * @param \fk_\StructType\Adres $adresi
     * @param \fk_\StructType\Iletisim $iletisimBilgileri
     * @param string $kodu
     * @param string $adi
     */
    public function __construct($aciklama = null, \fk_\StructType\BankaPointer $bankasi = null, \fk_\StructType\Adres $adresi = null, \fk_\StructType\Iletisim $iletisimBilgileri = null, $kodu = null, $adi = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setBankasi($bankasi)
            ->setAdresi($adresi)
            ->setIletisimBilgileri($iletisimBilgileri)
            ->setKodu($kodu)
            ->setAdi($adi);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\BankaSubesi
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Bankasi value
     * @return \fk_\StructType\BankaPointer|null
     */
    public function getBankasi()
    {
        return $this->Bankasi;
    }
    /**
     * Set Bankasi value
     * @param \fk_\StructType\BankaPointer $bankasi
     * @return \fk_\StructType\BankaSubesi
     */
    public function setBankasi(\fk_\StructType\BankaPointer $bankasi = null)
    {
        $this->Bankasi = $bankasi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \fk_\StructType\Adres|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \fk_\StructType\Adres $adresi
     * @return \fk_\StructType\BankaSubesi
     */
    public function setAdresi(\fk_\StructType\Adres $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get IletisimBilgileri value
     * @return \fk_\StructType\Iletisim|null
     */
    public function getIletisimBilgileri()
    {
        return $this->IletisimBilgileri;
    }
    /**
     * Set IletisimBilgileri value
     * @param \fk_\StructType\Iletisim $iletisimBilgileri
     * @return \fk_\StructType\BankaSubesi
     */
    public function setIletisimBilgileri(\fk_\StructType\Iletisim $iletisimBilgileri = null)
    {
        $this->IletisimBilgileri = $iletisimBilgileri;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \fk_\StructType\BankaSubesi
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\BankaSubesi
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\BankaSubesi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
