<?php

namespace fk_\EnumType;

/**
 * This class stands for AracDurum EnumType
 * @subpackage Enumerations
 */
class AracDurum
{
    /**
     * Constant for value 'Hazir'
     * @return string 'Hazir'
     */
    const VALUE_HAZIR = 'Hazir';
    /**
     * Constant for value 'SeferHazirlik'
     * @return string 'SeferHazirlik'
     */
    const VALUE_SEFER_HAZIRLIK = 'SeferHazirlik';
    /**
     * Constant for value 'SeferYukleme'
     * @return string 'SeferYukleme'
     */
    const VALUE_SEFER_YUKLEME = 'SeferYukleme';
    /**
     * Constant for value 'SeferBasladi'
     * @return string 'SeferBasladi'
     */
    const VALUE_SEFER_BASLADI = 'SeferBasladi';
    /**
     * Constant for value 'SeferBitti'
     * @return string 'SeferBitti'
     */
    const VALUE_SEFER_BITTI = 'SeferBitti';
    /**
     * Constant for value 'SeferBosaltma'
     * @return string 'SeferBosaltma'
     */
    const VALUE_SEFER_BOSALTMA = 'SeferBosaltma';
    /**
     * Constant for value 'Serviste'
     * @return string 'Serviste'
     */
    const VALUE_SERVISTE = 'Serviste';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HAZIR
     * @uses self::VALUE_SEFER_HAZIRLIK
     * @uses self::VALUE_SEFER_YUKLEME
     * @uses self::VALUE_SEFER_BASLADI
     * @uses self::VALUE_SEFER_BITTI
     * @uses self::VALUE_SEFER_BOSALTMA
     * @uses self::VALUE_SERVISTE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HAZIR,
            self::VALUE_SEFER_HAZIRLIK,
            self::VALUE_SEFER_YUKLEME,
            self::VALUE_SEFER_BASLADI,
            self::VALUE_SEFER_BITTI,
            self::VALUE_SEFER_BOSALTMA,
            self::VALUE_SERVISTE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
