<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KWebGonderiGirisi StructType
 * @subpackage Structs
 */
class KWebGonderiGirisi extends Entity
{
    /**
     * The IptalDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IptalDurum;
    /**
     * The OkutmaZamani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OkutmaZamani;
    /**
     * The IsLojistikEntegrasyon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLojistikEntegrasyon;
    /**
     * The EntegrasyonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EntegrasyonId;
    /**
     * The EntegrasyonHesaplamaTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntegrasyonHesaplamaTuru;
    /**
     * The KargoTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KargoTuru;
    /**
     * The OdemeTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeTipi;
    /**
     * The KargoAdet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KargoAdet;
    /**
     * The IsKapidanOdeme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKapidanOdeme;
    /**
     * The KapidanOdemeTahsilatTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KapidanOdemeTahsilatTipi;
    /**
     * The KapidanOdemeTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KapidanOdemeTutar;
    /**
     * The GonderiDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GonderiDurumu;
    /**
     * The Desi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Desi;
    /**
     * The Kg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kg;
    /**
     * The ToplamDesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamDesi;
    /**
     * The ToplamKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamKg;
    /**
     * The GonderininGelisSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GonderininGelisSekli;
    /**
     * The TeslimSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeslimSekli;
    /**
     * The TasimaSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TasimaSekli;
    /**
     * The IsCokluEvrakSatiri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCokluEvrakSatiri;
    /**
     * The ZimmetSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ZimmetSaati;
    /**
     * The BilgiTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BilgiTipi;
    /**
     * The KargoAdetText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KargoAdetText;
    /**
     * The DesiText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesiText;
    /**
     * The KgText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KgText;
    /**
     * The KapidanOdemeTutarText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KapidanOdemeTutarText;
    /**
     * The GonderenCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCari
     */
    public $GonderenCari;
    /**
     * The WebCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KWebCari
     */
    public $WebCari;
    /**
     * The KargoIcerigi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KargoIcerigi;
    /**
     * The EkHizmetler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EkHizmetler;
    /**
     * The ReferansNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferansNo;
    /**
     * The IrsaliyeNumarasiSeriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IrsaliyeNumarasiSeriNo;
    /**
     * The IrsaliyeNumarasiSiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IrsaliyeNumarasiSiraNo;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellum
     */
    public $Tesellum;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFatura
     */
    public $Fatura;
    /**
     * The OzelKargoTakipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OzelKargoTakipNo;
    /**
     * The GonderenDepartman
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KWebGonderenDepartman
     */
    public $GonderenDepartman;
    /**
     * The Kullanici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KWebKullanici
     */
    public $Kullanici;
    /**
     * The SahisBirim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SahisBirim;
    /**
     * The SevkAdresiAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SevkAdresiAdi;
    /**
     * The GonCepTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonCepTel;
    /**
     * The GonEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonEmail;
    /**
     * The GonEvTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonEvTel;
    /**
     * The GonIsTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonIsTel;
    /**
     * The GonVergiDaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonVergiDaire;
    /**
     * The GonVergiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonVergiNo;
    /**
     * The ZimmetlenenPersonel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KPersonel
     */
    public $ZimmetlenenPersonel;
    /**
     * Constructor method for KWebGonderiGirisi
     * @uses KWebGonderiGirisi::setIptalDurum()
     * @uses KWebGonderiGirisi::setOkutmaZamani()
     * @uses KWebGonderiGirisi::setIsLojistikEntegrasyon()
     * @uses KWebGonderiGirisi::setEntegrasyonId()
     * @uses KWebGonderiGirisi::setEntegrasyonHesaplamaTuru()
     * @uses KWebGonderiGirisi::setKargoTuru()
     * @uses KWebGonderiGirisi::setOdemeTipi()
     * @uses KWebGonderiGirisi::setKargoAdet()
     * @uses KWebGonderiGirisi::setIsKapidanOdeme()
     * @uses KWebGonderiGirisi::setKapidanOdemeTahsilatTipi()
     * @uses KWebGonderiGirisi::setKapidanOdemeTutar()
     * @uses KWebGonderiGirisi::setGonderiDurumu()
     * @uses KWebGonderiGirisi::setDesi()
     * @uses KWebGonderiGirisi::setKg()
     * @uses KWebGonderiGirisi::setToplamDesi()
     * @uses KWebGonderiGirisi::setToplamKg()
     * @uses KWebGonderiGirisi::setGonderininGelisSekli()
     * @uses KWebGonderiGirisi::setTeslimSekli()
     * @uses KWebGonderiGirisi::setTasimaSekli()
     * @uses KWebGonderiGirisi::setIsCokluEvrakSatiri()
     * @uses KWebGonderiGirisi::setZimmetSaati()
     * @uses KWebGonderiGirisi::setBilgiTipi()
     * @uses KWebGonderiGirisi::setKargoAdetText()
     * @uses KWebGonderiGirisi::setDesiText()
     * @uses KWebGonderiGirisi::setKgText()
     * @uses KWebGonderiGirisi::setKapidanOdemeTutarText()
     * @uses KWebGonderiGirisi::setGonderenCari()
     * @uses KWebGonderiGirisi::setWebCari()
     * @uses KWebGonderiGirisi::setKargoIcerigi()
     * @uses KWebGonderiGirisi::setEkHizmetler()
     * @uses KWebGonderiGirisi::setReferansNo()
     * @uses KWebGonderiGirisi::setIrsaliyeNumarasiSeriNo()
     * @uses KWebGonderiGirisi::setIrsaliyeNumarasiSiraNo()
     * @uses KWebGonderiGirisi::setTesellum()
     * @uses KWebGonderiGirisi::setFatura()
     * @uses KWebGonderiGirisi::setOzelKargoTakipNo()
     * @uses KWebGonderiGirisi::setGonderenDepartman()
     * @uses KWebGonderiGirisi::setKullanici()
     * @uses KWebGonderiGirisi::setSahisBirim()
     * @uses KWebGonderiGirisi::setSevkAdresiAdi()
     * @uses KWebGonderiGirisi::setGonCepTel()
     * @uses KWebGonderiGirisi::setGonEmail()
     * @uses KWebGonderiGirisi::setGonEvTel()
     * @uses KWebGonderiGirisi::setGonIsTel()
     * @uses KWebGonderiGirisi::setGonVergiDaire()
     * @uses KWebGonderiGirisi::setGonVergiNo()
     * @uses KWebGonderiGirisi::setZimmetlenenPersonel()
     * @param bool $iptalDurum
     * @param string $okutmaZamani
     * @param bool $isLojistikEntegrasyon
     * @param int $entegrasyonId
     * @param string $entegrasyonHesaplamaTuru
     * @param string $kargoTuru
     * @param string $odemeTipi
     * @param int $kargoAdet
     * @param bool $isKapidanOdeme
     * @param string $kapidanOdemeTahsilatTipi
     * @param float $kapidanOdemeTutar
     * @param string $gonderiDurumu
     * @param float $desi
     * @param float $kg
     * @param float $toplamDesi
     * @param float $toplamKg
     * @param string $gonderininGelisSekli
     * @param string $teslimSekli
     * @param string $tasimaSekli
     * @param bool $isCokluEvrakSatiri
     * @param string $zimmetSaati
     * @param int $bilgiTipi
     * @param string $kargoAdetText
     * @param string $desiText
     * @param string $kgText
     * @param string $kapidanOdemeTutarText
     * @param \fk_\StructType\KCari $gonderenCari
     * @param \fk_\StructType\KWebCari $webCari
     * @param string $kargoIcerigi
     * @param string $ekHizmetler
     * @param string $referansNo
     * @param string $irsaliyeNumarasiSeriNo
     * @param string $irsaliyeNumarasiSiraNo
     * @param \fk_\StructType\KTesellum $tesellum
     * @param \fk_\StructType\KFatura $fatura
     * @param string $ozelKargoTakipNo
     * @param \fk_\StructType\KWebGonderenDepartman $gonderenDepartman
     * @param \fk_\StructType\KWebKullanici $kullanici
     * @param string $sahisBirim
     * @param string $sevkAdresiAdi
     * @param string $gonCepTel
     * @param string $gonEmail
     * @param string $gonEvTel
     * @param string $gonIsTel
     * @param string $gonVergiDaire
     * @param string $gonVergiNo
     * @param \fk_\StructType\KPersonel $zimmetlenenPersonel
     */
    public function __construct($iptalDurum = null, $okutmaZamani = null, $isLojistikEntegrasyon = null, $entegrasyonId = null, $entegrasyonHesaplamaTuru = null, $kargoTuru = null, $odemeTipi = null, $kargoAdet = null, $isKapidanOdeme = null, $kapidanOdemeTahsilatTipi = null, $kapidanOdemeTutar = null, $gonderiDurumu = null, $desi = null, $kg = null, $toplamDesi = null, $toplamKg = null, $gonderininGelisSekli = null, $teslimSekli = null, $tasimaSekli = null, $isCokluEvrakSatiri = null, $zimmetSaati = null, $bilgiTipi = null, $kargoAdetText = null, $desiText = null, $kgText = null, $kapidanOdemeTutarText = null, \fk_\StructType\KCari $gonderenCari = null, \fk_\StructType\KWebCari $webCari = null, $kargoIcerigi = null, $ekHizmetler = null, $referansNo = null, $irsaliyeNumarasiSeriNo = null, $irsaliyeNumarasiSiraNo = null, \fk_\StructType\KTesellum $tesellum = null, \fk_\StructType\KFatura $fatura = null, $ozelKargoTakipNo = null, \fk_\StructType\KWebGonderenDepartman $gonderenDepartman = null, \fk_\StructType\KWebKullanici $kullanici = null, $sahisBirim = null, $sevkAdresiAdi = null, $gonCepTel = null, $gonEmail = null, $gonEvTel = null, $gonIsTel = null, $gonVergiDaire = null, $gonVergiNo = null, \fk_\StructType\KPersonel $zimmetlenenPersonel = null)
    {
        $this
            ->setIptalDurum($iptalDurum)
            ->setOkutmaZamani($okutmaZamani)
            ->setIsLojistikEntegrasyon($isLojistikEntegrasyon)
            ->setEntegrasyonId($entegrasyonId)
            ->setEntegrasyonHesaplamaTuru($entegrasyonHesaplamaTuru)
            ->setKargoTuru($kargoTuru)
            ->setOdemeTipi($odemeTipi)
            ->setKargoAdet($kargoAdet)
            ->setIsKapidanOdeme($isKapidanOdeme)
            ->setKapidanOdemeTahsilatTipi($kapidanOdemeTahsilatTipi)
            ->setKapidanOdemeTutar($kapidanOdemeTutar)
            ->setGonderiDurumu($gonderiDurumu)
            ->setDesi($desi)
            ->setKg($kg)
            ->setToplamDesi($toplamDesi)
            ->setToplamKg($toplamKg)
            ->setGonderininGelisSekli($gonderininGelisSekli)
            ->setTeslimSekli($teslimSekli)
            ->setTasimaSekli($tasimaSekli)
            ->setIsCokluEvrakSatiri($isCokluEvrakSatiri)
            ->setZimmetSaati($zimmetSaati)
            ->setBilgiTipi($bilgiTipi)
            ->setKargoAdetText($kargoAdetText)
            ->setDesiText($desiText)
            ->setKgText($kgText)
            ->setKapidanOdemeTutarText($kapidanOdemeTutarText)
            ->setGonderenCari($gonderenCari)
            ->setWebCari($webCari)
            ->setKargoIcerigi($kargoIcerigi)
            ->setEkHizmetler($ekHizmetler)
            ->setReferansNo($referansNo)
            ->setIrsaliyeNumarasiSeriNo($irsaliyeNumarasiSeriNo)
            ->setIrsaliyeNumarasiSiraNo($irsaliyeNumarasiSiraNo)
            ->setTesellum($tesellum)
            ->setFatura($fatura)
            ->setOzelKargoTakipNo($ozelKargoTakipNo)
            ->setGonderenDepartman($gonderenDepartman)
            ->setKullanici($kullanici)
            ->setSahisBirim($sahisBirim)
            ->setSevkAdresiAdi($sevkAdresiAdi)
            ->setGonCepTel($gonCepTel)
            ->setGonEmail($gonEmail)
            ->setGonEvTel($gonEvTel)
            ->setGonIsTel($gonIsTel)
            ->setGonVergiDaire($gonVergiDaire)
            ->setGonVergiNo($gonVergiNo)
            ->setZimmetlenenPersonel($zimmetlenenPersonel);
    }
    /**
     * Get IptalDurum value
     * @return bool
     */
    public function getIptalDurum()
    {
        return $this->IptalDurum;
    }
    /**
     * Set IptalDurum value
     * @param bool $iptalDurum
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIptalDurum($iptalDurum = null)
    {
        // validation for constraint: boolean
        if (!is_null($iptalDurum) && !is_bool($iptalDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iptalDurum, true), gettype($iptalDurum)), __LINE__);
        }
        $this->IptalDurum = $iptalDurum;
        return $this;
    }
    /**
     * Get OkutmaZamani value
     * @return string
     */
    public function getOkutmaZamani()
    {
        return $this->OkutmaZamani;
    }
    /**
     * Set OkutmaZamani value
     * @param string $okutmaZamani
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setOkutmaZamani($okutmaZamani = null)
    {
        // validation for constraint: string
        if (!is_null($okutmaZamani) && !is_string($okutmaZamani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okutmaZamani, true), gettype($okutmaZamani)), __LINE__);
        }
        $this->OkutmaZamani = $okutmaZamani;
        return $this;
    }
    /**
     * Get IsLojistikEntegrasyon value
     * @return bool
     */
    public function getIsLojistikEntegrasyon()
    {
        return $this->IsLojistikEntegrasyon;
    }
    /**
     * Set IsLojistikEntegrasyon value
     * @param bool $isLojistikEntegrasyon
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIsLojistikEntegrasyon($isLojistikEntegrasyon = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLojistikEntegrasyon) && !is_bool($isLojistikEntegrasyon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLojistikEntegrasyon, true), gettype($isLojistikEntegrasyon)), __LINE__);
        }
        $this->IsLojistikEntegrasyon = $isLojistikEntegrasyon;
        return $this;
    }
    /**
     * Get EntegrasyonId value
     * @return int
     */
    public function getEntegrasyonId()
    {
        return $this->EntegrasyonId;
    }
    /**
     * Set EntegrasyonId value
     * @param int $entegrasyonId
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setEntegrasyonId($entegrasyonId = null)
    {
        // validation for constraint: int
        if (!is_null($entegrasyonId) && !(is_int($entegrasyonId) || ctype_digit($entegrasyonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entegrasyonId, true), gettype($entegrasyonId)), __LINE__);
        }
        $this->EntegrasyonId = $entegrasyonId;
        return $this;
    }
    /**
     * Get EntegrasyonHesaplamaTuru value
     * @return string
     */
    public function getEntegrasyonHesaplamaTuru()
    {
        return $this->EntegrasyonHesaplamaTuru;
    }
    /**
     * Set EntegrasyonHesaplamaTuru value
     * @uses \fk_\EnumType\KWebGonderiGirisiHesaplamaTuru::valueIsValid()
     * @uses \fk_\EnumType\KWebGonderiGirisiHesaplamaTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entegrasyonHesaplamaTuru
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setEntegrasyonHesaplamaTuru($entegrasyonHesaplamaTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KWebGonderiGirisiHesaplamaTuru::valueIsValid($entegrasyonHesaplamaTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KWebGonderiGirisiHesaplamaTuru', is_array($entegrasyonHesaplamaTuru) ? implode(', ', $entegrasyonHesaplamaTuru) : var_export($entegrasyonHesaplamaTuru, true), implode(', ', \fk_\EnumType\KWebGonderiGirisiHesaplamaTuru::getValidValues())), __LINE__);
        }
        $this->EntegrasyonHesaplamaTuru = $entegrasyonHesaplamaTuru;
        return $this;
    }
    /**
     * Get KargoTuru value
     * @return string
     */
    public function getKargoTuru()
    {
        return $this->KargoTuru;
    }
    /**
     * Set KargoTuru value
     * @uses \fk_\EnumType\KWebKargoBirim::valueIsValid()
     * @uses \fk_\EnumType\KWebKargoBirim::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kargoTuru
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKargoTuru($kargoTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KWebKargoBirim::valueIsValid($kargoTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KWebKargoBirim', is_array($kargoTuru) ? implode(', ', $kargoTuru) : var_export($kargoTuru, true), implode(', ', \fk_\EnumType\KWebKargoBirim::getValidValues())), __LINE__);
        }
        $this->KargoTuru = $kargoTuru;
        return $this;
    }
    /**
     * Get OdemeTipi value
     * @return string
     */
    public function getOdemeTipi()
    {
        return $this->OdemeTipi;
    }
    /**
     * Set OdemeTipi value
     * @uses \fk_\EnumType\KWebKargoOdemeTipi::valueIsValid()
     * @uses \fk_\EnumType\KWebKargoOdemeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeTipi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setOdemeTipi($odemeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KWebKargoOdemeTipi::valueIsValid($odemeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KWebKargoOdemeTipi', is_array($odemeTipi) ? implode(', ', $odemeTipi) : var_export($odemeTipi, true), implode(', ', \fk_\EnumType\KWebKargoOdemeTipi::getValidValues())), __LINE__);
        }
        $this->OdemeTipi = $odemeTipi;
        return $this;
    }
    /**
     * Get KargoAdet value
     * @return int
     */
    public function getKargoAdet()
    {
        return $this->KargoAdet;
    }
    /**
     * Set KargoAdet value
     * @param int $kargoAdet
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKargoAdet($kargoAdet = null)
    {
        // validation for constraint: int
        if (!is_null($kargoAdet) && !(is_int($kargoAdet) || ctype_digit($kargoAdet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoAdet, true), gettype($kargoAdet)), __LINE__);
        }
        $this->KargoAdet = $kargoAdet;
        return $this;
    }
    /**
     * Get IsKapidanOdeme value
     * @return bool
     */
    public function getIsKapidanOdeme()
    {
        return $this->IsKapidanOdeme;
    }
    /**
     * Set IsKapidanOdeme value
     * @param bool $isKapidanOdeme
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIsKapidanOdeme($isKapidanOdeme = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKapidanOdeme) && !is_bool($isKapidanOdeme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKapidanOdeme, true), gettype($isKapidanOdeme)), __LINE__);
        }
        $this->IsKapidanOdeme = $isKapidanOdeme;
        return $this;
    }
    /**
     * Get KapidanOdemeTahsilatTipi value
     * @return string
     */
    public function getKapidanOdemeTahsilatTipi()
    {
        return $this->KapidanOdemeTahsilatTipi;
    }
    /**
     * Set KapidanOdemeTahsilatTipi value
     * @uses \fk_\EnumType\KTahsilatSecenegi::valueIsValid()
     * @uses \fk_\EnumType\KTahsilatSecenegi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kapidanOdemeTahsilatTipi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKapidanOdemeTahsilatTipi($kapidanOdemeTahsilatTipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KTahsilatSecenegi::valueIsValid($kapidanOdemeTahsilatTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KTahsilatSecenegi', is_array($kapidanOdemeTahsilatTipi) ? implode(', ', $kapidanOdemeTahsilatTipi) : var_export($kapidanOdemeTahsilatTipi, true), implode(', ', \fk_\EnumType\KTahsilatSecenegi::getValidValues())), __LINE__);
        }
        $this->KapidanOdemeTahsilatTipi = $kapidanOdemeTahsilatTipi;
        return $this;
    }
    /**
     * Get KapidanOdemeTutar value
     * @return float
     */
    public function getKapidanOdemeTutar()
    {
        return $this->KapidanOdemeTutar;
    }
    /**
     * Set KapidanOdemeTutar value
     * @param float $kapidanOdemeTutar
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKapidanOdemeTutar($kapidanOdemeTutar = null)
    {
        // validation for constraint: float
        if (!is_null($kapidanOdemeTutar) && !(is_float($kapidanOdemeTutar) || is_numeric($kapidanOdemeTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kapidanOdemeTutar, true), gettype($kapidanOdemeTutar)), __LINE__);
        }
        $this->KapidanOdemeTutar = $kapidanOdemeTutar;
        return $this;
    }
    /**
     * Get GonderiDurumu value
     * @return string
     */
    public function getGonderiDurumu()
    {
        return $this->GonderiDurumu;
    }
    /**
     * Set GonderiDurumu value
     * @uses \fk_\EnumType\KWebGonderiDurumu::valueIsValid()
     * @uses \fk_\EnumType\KWebGonderiDurumu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gonderiDurumu
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonderiDurumu($gonderiDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KWebGonderiDurumu::valueIsValid($gonderiDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KWebGonderiDurumu', is_array($gonderiDurumu) ? implode(', ', $gonderiDurumu) : var_export($gonderiDurumu, true), implode(', ', \fk_\EnumType\KWebGonderiDurumu::getValidValues())), __LINE__);
        }
        $this->GonderiDurumu = $gonderiDurumu;
        return $this;
    }
    /**
     * Get Desi value
     * @return float
     */
    public function getDesi()
    {
        return $this->Desi;
    }
    /**
     * Set Desi value
     * @param float $desi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setDesi($desi = null)
    {
        // validation for constraint: float
        if (!is_null($desi) && !(is_float($desi) || is_numeric($desi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desi, true), gettype($desi)), __LINE__);
        }
        $this->Desi = $desi;
        return $this;
    }
    /**
     * Get Kg value
     * @return float
     */
    public function getKg()
    {
        return $this->Kg;
    }
    /**
     * Set Kg value
     * @param float $kg
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKg($kg = null)
    {
        // validation for constraint: float
        if (!is_null($kg) && !(is_float($kg) || is_numeric($kg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kg, true), gettype($kg)), __LINE__);
        }
        $this->Kg = $kg;
        return $this;
    }
    /**
     * Get ToplamDesi value
     * @return float
     */
    public function getToplamDesi()
    {
        return $this->ToplamDesi;
    }
    /**
     * Set ToplamDesi value
     * @param float $toplamDesi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setToplamDesi($toplamDesi = null)
    {
        // validation for constraint: float
        if (!is_null($toplamDesi) && !(is_float($toplamDesi) || is_numeric($toplamDesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamDesi, true), gettype($toplamDesi)), __LINE__);
        }
        $this->ToplamDesi = $toplamDesi;
        return $this;
    }
    /**
     * Get ToplamKg value
     * @return float
     */
    public function getToplamKg()
    {
        return $this->ToplamKg;
    }
    /**
     * Set ToplamKg value
     * @param float $toplamKg
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setToplamKg($toplamKg = null)
    {
        // validation for constraint: float
        if (!is_null($toplamKg) && !(is_float($toplamKg) || is_numeric($toplamKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamKg, true), gettype($toplamKg)), __LINE__);
        }
        $this->ToplamKg = $toplamKg;
        return $this;
    }
    /**
     * Get GonderininGelisSekli value
     * @return string
     */
    public function getGonderininGelisSekli()
    {
        return $this->GonderininGelisSekli;
    }
    /**
     * Set GonderininGelisSekli value
     * @uses \fk_\EnumType\KWebGonderininGelisSekli::valueIsValid()
     * @uses \fk_\EnumType\KWebGonderininGelisSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gonderininGelisSekli
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonderininGelisSekli($gonderininGelisSekli = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KWebGonderininGelisSekli::valueIsValid($gonderininGelisSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KWebGonderininGelisSekli', is_array($gonderininGelisSekli) ? implode(', ', $gonderininGelisSekli) : var_export($gonderininGelisSekli, true), implode(', ', \fk_\EnumType\KWebGonderininGelisSekli::getValidValues())), __LINE__);
        }
        $this->GonderininGelisSekli = $gonderininGelisSekli;
        return $this;
    }
    /**
     * Get TeslimSekli value
     * @return string
     */
    public function getTeslimSekli()
    {
        return $this->TeslimSekli;
    }
    /**
     * Set TeslimSekli value
     * @uses \fk_\EnumType\KTeslimSekli::valueIsValid()
     * @uses \fk_\EnumType\KTeslimSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $teslimSekli
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setTeslimSekli($teslimSekli = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KTeslimSekli::valueIsValid($teslimSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KTeslimSekli', is_array($teslimSekli) ? implode(', ', $teslimSekli) : var_export($teslimSekli, true), implode(', ', \fk_\EnumType\KTeslimSekli::getValidValues())), __LINE__);
        }
        $this->TeslimSekli = $teslimSekli;
        return $this;
    }
    /**
     * Get TasimaSekli value
     * @return string
     */
    public function getTasimaSekli()
    {
        return $this->TasimaSekli;
    }
    /**
     * Set TasimaSekli value
     * @uses \fk_\EnumType\KAracTuru::valueIsValid()
     * @uses \fk_\EnumType\KAracTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tasimaSekli
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setTasimaSekli($tasimaSekli = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KAracTuru::valueIsValid($tasimaSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KAracTuru', is_array($tasimaSekli) ? implode(', ', $tasimaSekli) : var_export($tasimaSekli, true), implode(', ', \fk_\EnumType\KAracTuru::getValidValues())), __LINE__);
        }
        $this->TasimaSekli = $tasimaSekli;
        return $this;
    }
    /**
     * Get IsCokluEvrakSatiri value
     * @return bool
     */
    public function getIsCokluEvrakSatiri()
    {
        return $this->IsCokluEvrakSatiri;
    }
    /**
     * Set IsCokluEvrakSatiri value
     * @param bool $isCokluEvrakSatiri
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIsCokluEvrakSatiri($isCokluEvrakSatiri = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCokluEvrakSatiri) && !is_bool($isCokluEvrakSatiri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCokluEvrakSatiri, true), gettype($isCokluEvrakSatiri)), __LINE__);
        }
        $this->IsCokluEvrakSatiri = $isCokluEvrakSatiri;
        return $this;
    }
    /**
     * Get ZimmetSaati value
     * @return string
     */
    public function getZimmetSaati()
    {
        return $this->ZimmetSaati;
    }
    /**
     * Set ZimmetSaati value
     * @param string $zimmetSaati
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setZimmetSaati($zimmetSaati = null)
    {
        // validation for constraint: string
        if (!is_null($zimmetSaati) && !is_string($zimmetSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zimmetSaati, true), gettype($zimmetSaati)), __LINE__);
        }
        $this->ZimmetSaati = $zimmetSaati;
        return $this;
    }
    /**
     * Get BilgiTipi value
     * @return int
     */
    public function getBilgiTipi()
    {
        return $this->BilgiTipi;
    }
    /**
     * Set BilgiTipi value
     * @param int $bilgiTipi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setBilgiTipi($bilgiTipi = null)
    {
        // validation for constraint: int
        if (!is_null($bilgiTipi) && !(is_int($bilgiTipi) || ctype_digit($bilgiTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bilgiTipi, true), gettype($bilgiTipi)), __LINE__);
        }
        $this->BilgiTipi = $bilgiTipi;
        return $this;
    }
    /**
     * Get KargoAdetText value
     * @return string|null
     */
    public function getKargoAdetText()
    {
        return $this->KargoAdetText;
    }
    /**
     * Set KargoAdetText value
     * @param string $kargoAdetText
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKargoAdetText($kargoAdetText = null)
    {
        // validation for constraint: string
        if (!is_null($kargoAdetText) && !is_string($kargoAdetText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoAdetText, true), gettype($kargoAdetText)), __LINE__);
        }
        $this->KargoAdetText = $kargoAdetText;
        return $this;
    }
    /**
     * Get DesiText value
     * @return string|null
     */
    public function getDesiText()
    {
        return $this->DesiText;
    }
    /**
     * Set DesiText value
     * @param string $desiText
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setDesiText($desiText = null)
    {
        // validation for constraint: string
        if (!is_null($desiText) && !is_string($desiText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiText, true), gettype($desiText)), __LINE__);
        }
        $this->DesiText = $desiText;
        return $this;
    }
    /**
     * Get KgText value
     * @return string|null
     */
    public function getKgText()
    {
        return $this->KgText;
    }
    /**
     * Set KgText value
     * @param string $kgText
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKgText($kgText = null)
    {
        // validation for constraint: string
        if (!is_null($kgText) && !is_string($kgText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kgText, true), gettype($kgText)), __LINE__);
        }
        $this->KgText = $kgText;
        return $this;
    }
    /**
     * Get KapidanOdemeTutarText value
     * @return string|null
     */
    public function getKapidanOdemeTutarText()
    {
        return $this->KapidanOdemeTutarText;
    }
    /**
     * Set KapidanOdemeTutarText value
     * @param string $kapidanOdemeTutarText
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKapidanOdemeTutarText($kapidanOdemeTutarText = null)
    {
        // validation for constraint: string
        if (!is_null($kapidanOdemeTutarText) && !is_string($kapidanOdemeTutarText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kapidanOdemeTutarText, true), gettype($kapidanOdemeTutarText)), __LINE__);
        }
        $this->KapidanOdemeTutarText = $kapidanOdemeTutarText;
        return $this;
    }
    /**
     * Get GonderenCari value
     * @return \fk_\StructType\KCari|null
     */
    public function getGonderenCari()
    {
        return $this->GonderenCari;
    }
    /**
     * Set GonderenCari value
     * @param \fk_\StructType\KCari $gonderenCari
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonderenCari(\fk_\StructType\KCari $gonderenCari = null)
    {
        $this->GonderenCari = $gonderenCari;
        return $this;
    }
    /**
     * Get WebCari value
     * @return \fk_\StructType\KWebCari|null
     */
    public function getWebCari()
    {
        return $this->WebCari;
    }
    /**
     * Set WebCari value
     * @param \fk_\StructType\KWebCari $webCari
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setWebCari(\fk_\StructType\KWebCari $webCari = null)
    {
        $this->WebCari = $webCari;
        return $this;
    }
    /**
     * Get KargoIcerigi value
     * @return string|null
     */
    public function getKargoIcerigi()
    {
        return $this->KargoIcerigi;
    }
    /**
     * Set KargoIcerigi value
     * @param string $kargoIcerigi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKargoIcerigi($kargoIcerigi = null)
    {
        // validation for constraint: string
        if (!is_null($kargoIcerigi) && !is_string($kargoIcerigi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoIcerigi, true), gettype($kargoIcerigi)), __LINE__);
        }
        $this->KargoIcerigi = $kargoIcerigi;
        return $this;
    }
    /**
     * Get EkHizmetler value
     * @return string|null
     */
    public function getEkHizmetler()
    {
        return $this->EkHizmetler;
    }
    /**
     * Set EkHizmetler value
     * @param string $ekHizmetler
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setEkHizmetler($ekHizmetler = null)
    {
        // validation for constraint: string
        if (!is_null($ekHizmetler) && !is_string($ekHizmetler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ekHizmetler, true), gettype($ekHizmetler)), __LINE__);
        }
        $this->EkHizmetler = $ekHizmetler;
        return $this;
    }
    /**
     * Get ReferansNo value
     * @return string|null
     */
    public function getReferansNo()
    {
        return $this->ReferansNo;
    }
    /**
     * Set ReferansNo value
     * @param string $referansNo
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setReferansNo($referansNo = null)
    {
        // validation for constraint: string
        if (!is_null($referansNo) && !is_string($referansNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referansNo, true), gettype($referansNo)), __LINE__);
        }
        $this->ReferansNo = $referansNo;
        return $this;
    }
    /**
     * Get IrsaliyeNumarasiSeriNo value
     * @return string|null
     */
    public function getIrsaliyeNumarasiSeriNo()
    {
        return $this->IrsaliyeNumarasiSeriNo;
    }
    /**
     * Set IrsaliyeNumarasiSeriNo value
     * @param string $irsaliyeNumarasiSeriNo
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIrsaliyeNumarasiSeriNo($irsaliyeNumarasiSeriNo = null)
    {
        // validation for constraint: string
        if (!is_null($irsaliyeNumarasiSeriNo) && !is_string($irsaliyeNumarasiSeriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($irsaliyeNumarasiSeriNo, true), gettype($irsaliyeNumarasiSeriNo)), __LINE__);
        }
        $this->IrsaliyeNumarasiSeriNo = $irsaliyeNumarasiSeriNo;
        return $this;
    }
    /**
     * Get IrsaliyeNumarasiSiraNo value
     * @return string|null
     */
    public function getIrsaliyeNumarasiSiraNo()
    {
        return $this->IrsaliyeNumarasiSiraNo;
    }
    /**
     * Set IrsaliyeNumarasiSiraNo value
     * @param string $irsaliyeNumarasiSiraNo
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setIrsaliyeNumarasiSiraNo($irsaliyeNumarasiSiraNo = null)
    {
        // validation for constraint: string
        if (!is_null($irsaliyeNumarasiSiraNo) && !is_string($irsaliyeNumarasiSiraNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($irsaliyeNumarasiSiraNo, true), gettype($irsaliyeNumarasiSiraNo)), __LINE__);
        }
        $this->IrsaliyeNumarasiSiraNo = $irsaliyeNumarasiSiraNo;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellum|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellum $tesellum
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setTesellum(\fk_\StructType\KTesellum $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFatura|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFatura $fatura
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setFatura(\fk_\StructType\KFatura $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get OzelKargoTakipNo value
     * @return string|null
     */
    public function getOzelKargoTakipNo()
    {
        return $this->OzelKargoTakipNo;
    }
    /**
     * Set OzelKargoTakipNo value
     * @param string $ozelKargoTakipNo
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setOzelKargoTakipNo($ozelKargoTakipNo = null)
    {
        // validation for constraint: string
        if (!is_null($ozelKargoTakipNo) && !is_string($ozelKargoTakipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ozelKargoTakipNo, true), gettype($ozelKargoTakipNo)), __LINE__);
        }
        $this->OzelKargoTakipNo = $ozelKargoTakipNo;
        return $this;
    }
    /**
     * Get GonderenDepartman value
     * @return \fk_\StructType\KWebGonderenDepartman|null
     */
    public function getGonderenDepartman()
    {
        return $this->GonderenDepartman;
    }
    /**
     * Set GonderenDepartman value
     * @param \fk_\StructType\KWebGonderenDepartman $gonderenDepartman
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonderenDepartman(\fk_\StructType\KWebGonderenDepartman $gonderenDepartman = null)
    {
        $this->GonderenDepartman = $gonderenDepartman;
        return $this;
    }
    /**
     * Get Kullanici value
     * @return \fk_\StructType\KWebKullanici|null
     */
    public function getKullanici()
    {
        return $this->Kullanici;
    }
    /**
     * Set Kullanici value
     * @param \fk_\StructType\KWebKullanici $kullanici
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setKullanici(\fk_\StructType\KWebKullanici $kullanici = null)
    {
        $this->Kullanici = $kullanici;
        return $this;
    }
    /**
     * Get SahisBirim value
     * @return string|null
     */
    public function getSahisBirim()
    {
        return $this->SahisBirim;
    }
    /**
     * Set SahisBirim value
     * @param string $sahisBirim
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setSahisBirim($sahisBirim = null)
    {
        // validation for constraint: string
        if (!is_null($sahisBirim) && !is_string($sahisBirim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sahisBirim, true), gettype($sahisBirim)), __LINE__);
        }
        $this->SahisBirim = $sahisBirim;
        return $this;
    }
    /**
     * Get SevkAdresiAdi value
     * @return string|null
     */
    public function getSevkAdresiAdi()
    {
        return $this->SevkAdresiAdi;
    }
    /**
     * Set SevkAdresiAdi value
     * @param string $sevkAdresiAdi
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setSevkAdresiAdi($sevkAdresiAdi = null)
    {
        // validation for constraint: string
        if (!is_null($sevkAdresiAdi) && !is_string($sevkAdresiAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sevkAdresiAdi, true), gettype($sevkAdresiAdi)), __LINE__);
        }
        $this->SevkAdresiAdi = $sevkAdresiAdi;
        return $this;
    }
    /**
     * Get GonCepTel value
     * @return string|null
     */
    public function getGonCepTel()
    {
        return $this->GonCepTel;
    }
    /**
     * Set GonCepTel value
     * @param string $gonCepTel
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonCepTel($gonCepTel = null)
    {
        // validation for constraint: string
        if (!is_null($gonCepTel) && !is_string($gonCepTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonCepTel, true), gettype($gonCepTel)), __LINE__);
        }
        $this->GonCepTel = $gonCepTel;
        return $this;
    }
    /**
     * Get GonEmail value
     * @return string|null
     */
    public function getGonEmail()
    {
        return $this->GonEmail;
    }
    /**
     * Set GonEmail value
     * @param string $gonEmail
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonEmail($gonEmail = null)
    {
        // validation for constraint: string
        if (!is_null($gonEmail) && !is_string($gonEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonEmail, true), gettype($gonEmail)), __LINE__);
        }
        $this->GonEmail = $gonEmail;
        return $this;
    }
    /**
     * Get GonEvTel value
     * @return string|null
     */
    public function getGonEvTel()
    {
        return $this->GonEvTel;
    }
    /**
     * Set GonEvTel value
     * @param string $gonEvTel
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonEvTel($gonEvTel = null)
    {
        // validation for constraint: string
        if (!is_null($gonEvTel) && !is_string($gonEvTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonEvTel, true), gettype($gonEvTel)), __LINE__);
        }
        $this->GonEvTel = $gonEvTel;
        return $this;
    }
    /**
     * Get GonIsTel value
     * @return string|null
     */
    public function getGonIsTel()
    {
        return $this->GonIsTel;
    }
    /**
     * Set GonIsTel value
     * @param string $gonIsTel
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonIsTel($gonIsTel = null)
    {
        // validation for constraint: string
        if (!is_null($gonIsTel) && !is_string($gonIsTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonIsTel, true), gettype($gonIsTel)), __LINE__);
        }
        $this->GonIsTel = $gonIsTel;
        return $this;
    }
    /**
     * Get GonVergiDaire value
     * @return string|null
     */
    public function getGonVergiDaire()
    {
        return $this->GonVergiDaire;
    }
    /**
     * Set GonVergiDaire value
     * @param string $gonVergiDaire
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonVergiDaire($gonVergiDaire = null)
    {
        // validation for constraint: string
        if (!is_null($gonVergiDaire) && !is_string($gonVergiDaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonVergiDaire, true), gettype($gonVergiDaire)), __LINE__);
        }
        $this->GonVergiDaire = $gonVergiDaire;
        return $this;
    }
    /**
     * Get GonVergiNo value
     * @return string|null
     */
    public function getGonVergiNo()
    {
        return $this->GonVergiNo;
    }
    /**
     * Set GonVergiNo value
     * @param string $gonVergiNo
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setGonVergiNo($gonVergiNo = null)
    {
        // validation for constraint: string
        if (!is_null($gonVergiNo) && !is_string($gonVergiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonVergiNo, true), gettype($gonVergiNo)), __LINE__);
        }
        $this->GonVergiNo = $gonVergiNo;
        return $this;
    }
    /**
     * Get ZimmetlenenPersonel value
     * @return \fk_\StructType\KPersonel|null
     */
    public function getZimmetlenenPersonel()
    {
        return $this->ZimmetlenenPersonel;
    }
    /**
     * Set ZimmetlenenPersonel value
     * @param \fk_\StructType\KPersonel $zimmetlenenPersonel
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public function setZimmetlenenPersonel(\fk_\StructType\KPersonel $zimmetlenenPersonel = null)
    {
        $this->ZimmetlenenPersonel = $zimmetlenenPersonel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KWebGonderiGirisi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
