<?php

namespace fk_\EnumType;

/**
 * This class stands for KSeferYonTip EnumType
 * @subpackage Enumerations
 */
class KSeferYonTip
{
    /**
     * Constant for value 'Gidis'
     * @return string 'Gidis'
     */
    const VALUE_GIDIS = 'Gidis';
    /**
     * Constant for value 'Donus'
     * @return string 'Donus'
     */
    const VALUE_DONUS = 'Donus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIDIS
     * @uses self::VALUE_DONUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIDIS,
            self::VALUE_DONUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
