<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebGonderiDurumu EnumType
 * @subpackage Enumerations
 */
class KWebGonderiDurumu
{
    /**
     * Constant for value 'AktifGonderi'
     * @return string 'AktifGonderi'
     */
    const VALUE_AKTIF_GONDERI = 'AktifGonderi';
    /**
     * Constant for value 'TeslimEdildi'
     * @return string 'TeslimEdildi'
     */
    const VALUE_TESLIM_EDILDI = 'TeslimEdildi';
    /**
     * Constant for value 'IptalEdildi'
     * @return string 'IptalEdildi'
     */
    const VALUE_IPTAL_EDILDI = 'IptalEdildi';
    /**
     * Constant for value 'Faturalandi'
     * @return string 'Faturalandi'
     */
    const VALUE_FATURALANDI = 'Faturalandi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AKTIF_GONDERI
     * @uses self::VALUE_TESLIM_EDILDI
     * @uses self::VALUE_IPTAL_EDILDI
     * @uses self::VALUE_FATURALANDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AKTIF_GONDERI,
            self::VALUE_TESLIM_EDILDI,
            self::VALUE_IPTAL_EDILDI,
            self::VALUE_FATURALANDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
