<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracCins EnumType
 * @subpackage Enumerations
 */
class KAracCins
{
    /**
     * Constant for value 'Kamyonet'
     * @return string 'Kamyonet'
     */
    const VALUE_KAMYONET = 'Kamyonet';
    /**
     * Constant for value 'Kamyon'
     * @return string 'Kamyon'
     */
    const VALUE_KAMYON = 'Kamyon';
    /**
     * Constant for value 'Minibus'
     * @return string 'Minibus'
     */
    const VALUE_MINIBUS = 'Minibus';
    /**
     * Constant for value 'TIR'
     * @return string 'TIR'
     */
    const VALUE_TIR = 'TIR';
    /**
     * Constant for value 'Panelvan'
     * @return string 'Panelvan'
     */
    const VALUE_PANELVAN = 'Panelvan';
    /**
     * Constant for value 'MiniVan'
     * @return string 'MiniVan'
     */
    const VALUE_MINI_VAN = 'MiniVan';
    /**
     * Constant for value 'HususiOto'
     * @return string 'HususiOto'
     */
    const VALUE_HUSUSI_OTO = 'HususiOto';
    /**
     * Constant for value 'Motosiklet'
     * @return string 'Motosiklet'
     */
    const VALUE_MOTOSIKLET = 'Motosiklet';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAMYONET
     * @uses self::VALUE_KAMYON
     * @uses self::VALUE_MINIBUS
     * @uses self::VALUE_TIR
     * @uses self::VALUE_PANELVAN
     * @uses self::VALUE_MINI_VAN
     * @uses self::VALUE_HUSUSI_OTO
     * @uses self::VALUE_MOTOSIKLET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAMYONET,
            self::VALUE_KAMYON,
            self::VALUE_MINIBUS,
            self::VALUE_TIR,
            self::VALUE_PANELVAN,
            self::VALUE_MINI_VAN,
            self::VALUE_HUSUSI_OTO,
            self::VALUE_MOTOSIKLET,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
