<?php

namespace fk_\EnumType;

/**
 * This class stands for HatYonTip EnumType
 * @subpackage Enumerations
 */
class HatYonTip
{
    /**
     * Constant for value 'TekYon'
     * @return string 'TekYon'
     */
    const VALUE_TEK_YON = 'TekYon';
    /**
     * Constant for value 'CiftYon'
     * @return string 'CiftYon'
     */
    const VALUE_CIFT_YON = 'CiftYon';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEK_YON
     * @uses self::VALUE_CIFT_YON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEK_YON,
            self::VALUE_CIFT_YON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
