<?php

namespace fk_\EnumType;

/**
 * This class stands for KargoyaGonderildimi EnumType
 * @subpackage Enumerations
 */
class KargoyaGonderildimi
{
    /**
     * Constant for value 'Gonderilmedi'
     * @return string 'Gonderilmedi'
     */
    const VALUE_GONDERILMEDI = 'Gonderilmedi';
    /**
     * Constant for value 'Gonderildi'
     * @return string 'Gonderildi'
     */
    const VALUE_GONDERILDI = 'Gonderildi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GONDERILMEDI
     * @uses self::VALUE_GONDERILDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GONDERILMEDI,
            self::VALUE_GONDERILDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
