<?php

namespace fk_\EnumType;

/**
 * This class stands for KSozlesmeFiyatHesaplamaKriteri EnumType
 * @subpackage Enumerations
 */
class KSozlesmeFiyatHesaplamaKriteri
{
    /**
     * Constant for value 'DesiKgdenBuyugeGoreHesapla'
     * @return string 'DesiKgdenBuyugeGoreHesapla'
     */
    const VALUE_DESI_KGDEN_BUYUGE_GORE_HESAPLA = 'DesiKgdenBuyugeGoreHesapla';
    /**
     * Constant for value 'DesidenHesapla'
     * @return string 'DesidenHesapla'
     */
    const VALUE_DESIDEN_HESAPLA = 'DesidenHesapla';
    /**
     * Constant for value 'KgdenHesapla'
     * @return string 'KgdenHesapla'
     */
    const VALUE_KGDEN_HESAPLA = 'KgdenHesapla';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DESI_KGDEN_BUYUGE_GORE_HESAPLA
     * @uses self::VALUE_DESIDEN_HESAPLA
     * @uses self::VALUE_KGDEN_HESAPLA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DESI_KGDEN_BUYUGE_GORE_HESAPLA,
            self::VALUE_DESIDEN_HESAPLA,
            self::VALUE_KGDEN_HESAPLA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
