<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracKullanimSekli EnumType
 * @subpackage Enumerations
 */
class KAracKullanimSekli
{
    /**
     * Constant for value 'Sevkiyat'
     * @return string 'Sevkiyat'
     */
    const VALUE_SEVKIYAT = 'Sevkiyat';
    /**
     * Constant for value 'Hizmet'
     * @return string 'Hizmet'
     */
    const VALUE_HIZMET = 'Hizmet';
    /**
     * Constant for value 'Sube'
     * @return string 'Sube'
     */
    const VALUE_SUBE = 'Sube';
    /**
     * Constant for value 'Ring'
     * @return string 'Ring'
     */
    const VALUE_RING = 'Ring';
    /**
     * Constant for value 'Anahat'
     * @return string 'Anahat'
     */
    const VALUE_ANAHAT = 'Anahat';
    /**
     * Constant for value 'Arahat'
     * @return string 'Arahat'
     */
    const VALUE_ARAHAT = 'Arahat';
    /**
     * Constant for value 'GenelMudurluk'
     * @return string 'GenelMudurluk'
     */
    const VALUE_GENEL_MUDURLUK = 'GenelMudurluk';
    /**
     * Constant for value 'BolgeHizmetAraci'
     * @return string 'BolgeHizmetAraci'
     */
    const VALUE_BOLGE_HIZMET_ARACI = 'BolgeHizmetAraci';
    /**
     * Constant for value 'BolgePazarlama'
     * @return string 'BolgePazarlama'
     */
    const VALUE_BOLGE_PAZARLAMA = 'BolgePazarlama';
    /**
     * Constant for value 'Pazarlama'
     * @return string 'Pazarlama'
     */
    const VALUE_PAZARLAMA = 'Pazarlama';
    /**
     * Constant for value 'IsTakibi'
     * @return string 'IsTakibi'
     */
    const VALUE_IS_TAKIBI = 'IsTakibi';
    /**
     * Constant for value 'Acente'
     * @return string 'Acente'
     */
    const VALUE_ACENTE = 'Acente';
    /**
     * Constant for value 'Ucak'
     * @return string 'Ucak'
     */
    const VALUE_UCAK = 'Ucak';
    /**
     * Constant for value 'Motosiklet'
     * @return string 'Motosiklet'
     */
    const VALUE_MOTOSIKLET = 'Motosiklet';
    /**
     * Constant for value 'ForkLift'
     * @return string 'ForkLift'
     */
    const VALUE_FORK_LIFT = 'ForkLift';
    /**
     * Constant for value 'SüratLojistik'
     * @return string 'SüratLojistik'
     */
    const VALUE_S_ÜRAT_LOJISTIK = 'SüratLojistik';
    /**
     * Constant for value 'Acente_UDK_Kiralık'
     * @return string 'Acente_UDK_Kiralık'
     */
    const VALUE_ACENTE_UDK_KIRAL_IK = 'Acente_UDK_Kiralık';
    /**
     * Constant for value 'Havuz'
     * @return string 'Havuz'
     */
    const VALUE_HAVUZ = 'Havuz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEVKIYAT
     * @uses self::VALUE_HIZMET
     * @uses self::VALUE_SUBE
     * @uses self::VALUE_RING
     * @uses self::VALUE_ANAHAT
     * @uses self::VALUE_ARAHAT
     * @uses self::VALUE_GENEL_MUDURLUK
     * @uses self::VALUE_BOLGE_HIZMET_ARACI
     * @uses self::VALUE_BOLGE_PAZARLAMA
     * @uses self::VALUE_PAZARLAMA
     * @uses self::VALUE_IS_TAKIBI
     * @uses self::VALUE_ACENTE
     * @uses self::VALUE_UCAK
     * @uses self::VALUE_MOTOSIKLET
     * @uses self::VALUE_FORK_LIFT
     * @uses self::VALUE_S_ÜRAT_LOJISTIK
     * @uses self::VALUE_ACENTE_UDK_KIRAL_IK
     * @uses self::VALUE_HAVUZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEVKIYAT,
            self::VALUE_HIZMET,
            self::VALUE_SUBE,
            self::VALUE_RING,
            self::VALUE_ANAHAT,
            self::VALUE_ARAHAT,
            self::VALUE_GENEL_MUDURLUK,
            self::VALUE_BOLGE_HIZMET_ARACI,
            self::VALUE_BOLGE_PAZARLAMA,
            self::VALUE_PAZARLAMA,
            self::VALUE_IS_TAKIBI,
            self::VALUE_ACENTE,
            self::VALUE_UCAK,
            self::VALUE_MOTOSIKLET,
            self::VALUE_FORK_LIFT,
            self::VALUE_S_ÜRAT_LOJISTIK,
            self::VALUE_ACENTE_UDK_KIRAL_IK,
            self::VALUE_HAVUZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
