<?php

namespace fk_\EnumType;

/**
 * This class stands for KTeslimSekli EnumType
 * @subpackage Enumerations
 */
class KTeslimSekli
{
    /**
     * Constant for value 'AdreseTeslim'
     * @return string 'AdreseTeslim'
     */
    const VALUE_ADRESE_TESLIM = 'AdreseTeslim';
    /**
     * Constant for value 'SubedeTeslim'
     * @return string 'SubedeTeslim'
     */
    const VALUE_SUBEDE_TESLIM = 'SubedeTeslim';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADRESE_TESLIM
     * @uses self::VALUE_SUBEDE_TESLIM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADRESE_TESLIM,
            self::VALUE_SUBEDE_TESLIM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
