<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKOTaksit StructType
 * @subpackage Structs
 */
class KKOTaksit extends SerendipEntity
{
    /**
     * The VadeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VadeTarihi;
    /**
     * The TaksitSayisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaksitSayisi;
    /**
     * The TaksitNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaksitNo;
    /**
     * The EvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTuru;
    /**
     * The SiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SiraNo;
    /**
     * The Durumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durumu;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellum
     */
    public $Tesellum;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFatura
     */
    public $Fatura;
    /**
     * The SeriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeriNo;
    /**
     * The KargoKesintiBedeli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $KargoKesintiBedeli;
    /**
     * The TaksitTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $TaksitTutari;
    /**
     * The OdenecekTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $OdenecekTutar;
    /**
     * The KOCariHareketi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KKOCariHareketiPointer
     */
    public $KOCariHareketi;
    /**
     * Constructor method for KKOTaksit
     * @uses KKOTaksit::setVadeTarihi()
     * @uses KKOTaksit::setTaksitSayisi()
     * @uses KKOTaksit::setTaksitNo()
     * @uses KKOTaksit::setEvrakTuru()
     * @uses KKOTaksit::setSiraNo()
     * @uses KKOTaksit::setDurumu()
     * @uses KKOTaksit::setTesellum()
     * @uses KKOTaksit::setFatura()
     * @uses KKOTaksit::setSeriNo()
     * @uses KKOTaksit::setKargoKesintiBedeli()
     * @uses KKOTaksit::setTaksitTutari()
     * @uses KKOTaksit::setOdenecekTutar()
     * @uses KKOTaksit::setKOCariHareketi()
     * @param string $vadeTarihi
     * @param int $taksitSayisi
     * @param int $taksitNo
     * @param string $evrakTuru
     * @param float $siraNo
     * @param string $durumu
     * @param \fk_\StructType\KTesellum $tesellum
     * @param \fk_\StructType\KFatura $fatura
     * @param string $seriNo
     * @param \fk_\StructType\DovizliTutar $kargoKesintiBedeli
     * @param \fk_\StructType\DovizliTutar $taksitTutari
     * @param \fk_\StructType\DovizliTutar $odenecekTutar
     * @param \fk_\StructType\KKOCariHareketiPointer $kOCariHareketi
     */
    public function __construct($vadeTarihi = null, $taksitSayisi = null, $taksitNo = null, $evrakTuru = null, $siraNo = null, $durumu = null, \fk_\StructType\KTesellum $tesellum = null, \fk_\StructType\KFatura $fatura = null, $seriNo = null, \fk_\StructType\DovizliTutar $kargoKesintiBedeli = null, \fk_\StructType\DovizliTutar $taksitTutari = null, \fk_\StructType\DovizliTutar $odenecekTutar = null, \fk_\StructType\KKOCariHareketiPointer $kOCariHareketi = null)
    {
        $this
            ->setVadeTarihi($vadeTarihi)
            ->setTaksitSayisi($taksitSayisi)
            ->setTaksitNo($taksitNo)
            ->setEvrakTuru($evrakTuru)
            ->setSiraNo($siraNo)
            ->setDurumu($durumu)
            ->setTesellum($tesellum)
            ->setFatura($fatura)
            ->setSeriNo($seriNo)
            ->setKargoKesintiBedeli($kargoKesintiBedeli)
            ->setTaksitTutari($taksitTutari)
            ->setOdenecekTutar($odenecekTutar)
            ->setKOCariHareketi($kOCariHareketi);
    }
    /**
     * Get VadeTarihi value
     * @return string
     */
    public function getVadeTarihi()
    {
        return $this->VadeTarihi;
    }
    /**
     * Set VadeTarihi value
     * @param string $vadeTarihi
     * @return \fk_\StructType\KKOTaksit
     */
    public function setVadeTarihi($vadeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($vadeTarihi) && !is_string($vadeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vadeTarihi, true), gettype($vadeTarihi)), __LINE__);
        }
        $this->VadeTarihi = $vadeTarihi;
        return $this;
    }
    /**
     * Get TaksitSayisi value
     * @return int
     */
    public function getTaksitSayisi()
    {
        return $this->TaksitSayisi;
    }
    /**
     * Set TaksitSayisi value
     * @param int $taksitSayisi
     * @return \fk_\StructType\KKOTaksit
     */
    public function setTaksitSayisi($taksitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($taksitSayisi) && !(is_int($taksitSayisi) || ctype_digit($taksitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taksitSayisi, true), gettype($taksitSayisi)), __LINE__);
        }
        $this->TaksitSayisi = $taksitSayisi;
        return $this;
    }
    /**
     * Get TaksitNo value
     * @return int
     */
    public function getTaksitNo()
    {
        return $this->TaksitNo;
    }
    /**
     * Set TaksitNo value
     * @param int $taksitNo
     * @return \fk_\StructType\KKOTaksit
     */
    public function setTaksitNo($taksitNo = null)
    {
        // validation for constraint: int
        if (!is_null($taksitNo) && !(is_int($taksitNo) || ctype_digit($taksitNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taksitNo, true), gettype($taksitNo)), __LINE__);
        }
        $this->TaksitNo = $taksitNo;
        return $this;
    }
    /**
     * Get EvrakTuru value
     * @return string
     */
    public function getEvrakTuru()
    {
        return $this->EvrakTuru;
    }
    /**
     * Set EvrakTuru value
     * @uses \fk_\EnumType\FATTES::valueIsValid()
     * @uses \fk_\EnumType\FATTES::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $evrakTuru
     * @return \fk_\StructType\KKOTaksit
     */
    public function setEvrakTuru($evrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\FATTES::valueIsValid($evrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\FATTES', is_array($evrakTuru) ? implode(', ', $evrakTuru) : var_export($evrakTuru, true), implode(', ', \fk_\EnumType\FATTES::getValidValues())), __LINE__);
        }
        $this->EvrakTuru = $evrakTuru;
        return $this;
    }
    /**
     * Get SiraNo value
     * @return float
     */
    public function getSiraNo()
    {
        return $this->SiraNo;
    }
    /**
     * Set SiraNo value
     * @param float $siraNo
     * @return \fk_\StructType\KKOTaksit
     */
    public function setSiraNo($siraNo = null)
    {
        // validation for constraint: float
        if (!is_null($siraNo) && !(is_float($siraNo) || is_numeric($siraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($siraNo, true), gettype($siraNo)), __LINE__);
        }
        $this->SiraNo = $siraNo;
        return $this;
    }
    /**
     * Get Durumu value
     * @return string
     */
    public function getDurumu()
    {
        return $this->Durumu;
    }
    /**
     * Set Durumu value
     * @uses \fk_\EnumType\KKOTaksitDurum::valueIsValid()
     * @uses \fk_\EnumType\KKOTaksitDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durumu
     * @return \fk_\StructType\KKOTaksit
     */
    public function setDurumu($durumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KKOTaksitDurum::valueIsValid($durumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KKOTaksitDurum', is_array($durumu) ? implode(', ', $durumu) : var_export($durumu, true), implode(', ', \fk_\EnumType\KKOTaksitDurum::getValidValues())), __LINE__);
        }
        $this->Durumu = $durumu;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellum|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellum $tesellum
     * @return \fk_\StructType\KKOTaksit
     */
    public function setTesellum(\fk_\StructType\KTesellum $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFatura|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFatura $fatura
     * @return \fk_\StructType\KKOTaksit
     */
    public function setFatura(\fk_\StructType\KFatura $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get SeriNo value
     * @return string|null
     */
    public function getSeriNo()
    {
        return $this->SeriNo;
    }
    /**
     * Set SeriNo value
     * @param string $seriNo
     * @return \fk_\StructType\KKOTaksit
     */
    public function setSeriNo($seriNo = null)
    {
        // validation for constraint: string
        if (!is_null($seriNo) && !is_string($seriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriNo, true), gettype($seriNo)), __LINE__);
        }
        $this->SeriNo = $seriNo;
        return $this;
    }
    /**
     * Get KargoKesintiBedeli value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getKargoKesintiBedeli()
    {
        return $this->KargoKesintiBedeli;
    }
    /**
     * Set KargoKesintiBedeli value
     * @param \fk_\StructType\DovizliTutar $kargoKesintiBedeli
     * @return \fk_\StructType\KKOTaksit
     */
    public function setKargoKesintiBedeli(\fk_\StructType\DovizliTutar $kargoKesintiBedeli = null)
    {
        $this->KargoKesintiBedeli = $kargoKesintiBedeli;
        return $this;
    }
    /**
     * Get TaksitTutari value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getTaksitTutari()
    {
        return $this->TaksitTutari;
    }
    /**
     * Set TaksitTutari value
     * @param \fk_\StructType\DovizliTutar $taksitTutari
     * @return \fk_\StructType\KKOTaksit
     */
    public function setTaksitTutari(\fk_\StructType\DovizliTutar $taksitTutari = null)
    {
        $this->TaksitTutari = $taksitTutari;
        return $this;
    }
    /**
     * Get OdenecekTutar value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getOdenecekTutar()
    {
        return $this->OdenecekTutar;
    }
    /**
     * Set OdenecekTutar value
     * @param \fk_\StructType\DovizliTutar $odenecekTutar
     * @return \fk_\StructType\KKOTaksit
     */
    public function setOdenecekTutar(\fk_\StructType\DovizliTutar $odenecekTutar = null)
    {
        $this->OdenecekTutar = $odenecekTutar;
        return $this;
    }
    /**
     * Get KOCariHareketi value
     * @return \fk_\StructType\KKOCariHareketiPointer|null
     */
    public function getKOCariHareketi()
    {
        return $this->KOCariHareketi;
    }
    /**
     * Set KOCariHareketi value
     * @param \fk_\StructType\KKOCariHareketiPointer $kOCariHareketi
     * @return \fk_\StructType\KKOTaksit
     */
    public function setKOCariHareketi(\fk_\StructType\KKOCariHareketiPointer $kOCariHareketi = null)
    {
        $this->KOCariHareketi = $kOCariHareketi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KKOTaksit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
