<?php

namespace fk_\EnumType;

/**
 * This class stands for ProjeTur EnumType
 * @subpackage Enumerations
 */
class ProjeTur
{
    /**
     * Constant for value 'Genel'
     * @return string 'Genel'
     */
    const VALUE_GENEL = 'Genel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
