<?php

namespace fk_\EnumType;

/**
 * This class stands for KEvrakIptalSebebi EnumType
 * @subpackage Enumerations
 */
class KEvrakIptalSebebi
{
    /**
     * Constant for value 'FiyataItiraz'
     * @return string 'FiyataItiraz'
     */
    const VALUE_FIYATA_ITIRAZ = 'FiyataItiraz';
    /**
     * Constant for value 'DesiVeAgirligaItiraz'
     * @return string 'DesiVeAgirligaItiraz'
     */
    const VALUE_DESI_VE_AGIRLIGA_ITIRAZ = 'DesiVeAgirligaItiraz';
    /**
     * Constant for value 'AnlasmayaItiraz'
     * @return string 'AnlasmayaItiraz'
     */
    const VALUE_ANLASMAYA_ITIRAZ = 'AnlasmayaItiraz';
    /**
     * Constant for value 'OdemeTipineItiraz'
     * @return string 'OdemeTipineItiraz'
     */
    const VALUE_ODEME_TIPINE_ITIRAZ = 'OdemeTipineItiraz';
    /**
     * Constant for value 'EvrakYazarkenKaydirmaHatasi'
     * @return string 'EvrakYazarkenKaydirmaHatasi'
     */
    const VALUE_EVRAK_YAZARKEN_KAYDIRMA_HATASI = 'EvrakYazarkenKaydirmaHatasi';
    /**
     * Constant for value 'EvrakTuruHatasi'
     * @return string 'EvrakTuruHatasi'
     */
    const VALUE_EVRAK_TURU_HATASI = 'EvrakTuruHatasi';
    /**
     * Constant for value 'KargoIadedenDolayi'
     * @return string 'KargoIadedenDolayi'
     */
    const VALUE_KARGO_IADEDEN_DOLAYI = 'KargoIadedenDolayi';
    /**
     * Constant for value 'KargoIptal'
     * @return string 'KargoIptal'
     */
    const VALUE_KARGO_IPTAL = 'KargoIptal';
    /**
     * Constant for value 'KargoHaricTumdenIptal'
     * @return string 'KargoHaricTumdenIptal'
     */
    const VALUE_KARGO_HARIC_TUMDEN_IPTAL = 'KargoHaricTumdenIptal';
    /**
     * Constant for value 'KEK'
     * @return string 'KEK'
     */
    const VALUE_KEK = 'KEK';
    /**
     * Constant for value 'EArsivNedeniyleIptal'
     * @return string 'EArsivNedeniyleIptal'
     */
    const VALUE_EARSIV_NEDENIYLE_IPTAL = 'EArsivNedeniyleIptal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIYATA_ITIRAZ
     * @uses self::VALUE_DESI_VE_AGIRLIGA_ITIRAZ
     * @uses self::VALUE_ANLASMAYA_ITIRAZ
     * @uses self::VALUE_ODEME_TIPINE_ITIRAZ
     * @uses self::VALUE_EVRAK_YAZARKEN_KAYDIRMA_HATASI
     * @uses self::VALUE_EVRAK_TURU_HATASI
     * @uses self::VALUE_KARGO_IADEDEN_DOLAYI
     * @uses self::VALUE_KARGO_IPTAL
     * @uses self::VALUE_KARGO_HARIC_TUMDEN_IPTAL
     * @uses self::VALUE_KEK
     * @uses self::VALUE_EARSIV_NEDENIYLE_IPTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIYATA_ITIRAZ,
            self::VALUE_DESI_VE_AGIRLIGA_ITIRAZ,
            self::VALUE_ANLASMAYA_ITIRAZ,
            self::VALUE_ODEME_TIPINE_ITIRAZ,
            self::VALUE_EVRAK_YAZARKEN_KAYDIRMA_HATASI,
            self::VALUE_EVRAK_TURU_HATASI,
            self::VALUE_KARGO_IADEDEN_DOLAYI,
            self::VALUE_KARGO_IPTAL,
            self::VALUE_KARGO_HARIC_TUMDEN_IPTAL,
            self::VALUE_KEK,
            self::VALUE_EARSIV_NEDENIYLE_IPTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
