<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KCari StructType
 * @subpackage Structs
 */
class KCari extends Entity
{
    /**
     * The Durumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durumu;
    /**
     * The HesapBlokToleransGunSayisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HesapBlokToleransGunSayisi;
    /**
     * The HesapKapamaBakiye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $HesapKapamaBakiye;
    /**
     * The HesapKapamaDonemi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HesapKapamaDonemi;
    /**
     * The HesapKapamaGunu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HesapKapamaGunu;
    /**
     * The HesapKapamaMinOdemeTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $HesapKapamaMinOdemeTutar;
    /**
     * The HesapTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HesapTipi;
    /**
     * The IsBlocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBlocked;
    /**
     * The IsUstCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsUstCari;
    /**
     * The OdemeGun
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OdemeGun;
    /**
     * The OdemeTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OdemeTip;
    /**
     * The Ozellik1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ozellik1;
    /**
     * The Ozellik2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ozellik2;
    /**
     * The SP_CariMuhasebeHesapSablonuObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_CariMuhasebeHesapSablonuObjId;
    /**
     * The SP_CariObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_CariObjId;
    /**
     * The SP_MuhasebeKoduObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_MuhasebeKoduObjId;
    /**
     * The SP_OdemePlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_OdemePlani;
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Turu;
    /**
     * The UAAliciCariHesapKapamaLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UAAliciCariHesapKapamaLimiti;
    /**
     * The UAEvrakLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UAEvrakLimiti;
    /**
     * The UAGonderenCariLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UAGonderenCariLimiti;
    /**
     * The UAGonderiKarsiBakiyeToplami
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UAGonderiKarsiBakiyeToplami;
    /**
     * The IsWebSatisiVar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWebSatisiVar;
    /**
     * The IsGitGel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGitGel;
    /**
     * The IsKapidanTahsilat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKapidanTahsilat;
    /**
     * The IsCariSozlesmeRaporu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCariSozlesmeRaporu;
    /**
     * The PazarlamaciDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PazarlamaciDurumu;
    /**
     * The isTCCitizen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isTCCitizen;
    /**
     * The IsIadeOnayVerilsin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIadeOnayVerilsin;
    /**
     * The IsCariKilitli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCariKilitli;
    /**
     * The EKargoSmsleGirisOlsunYeni
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EKargoSmsleGirisOlsunYeni;
    /**
     * The IlceKontroluOlmasin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IlceKontroluOlmasin;
    /**
     * The IsPazaryeriMusterisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPazaryeriMusterisi;
    /**
     * The TeslimatSubeObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TeslimatSubeObjId;
    /**
     * The GelenWebCariObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GelenWebCariObjId;
    /**
     * The IsCepTelZorunlu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCepTelZorunlu;
    /**
     * The DogumYili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DogumYili;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAdresPointer
     */
    public $Adresi;
    /**
     * The CepTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CepTel;
    /**
     * The EmailTeslimat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTeslimat;
    /**
     * The EvTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvTel;
    /**
     * The FaturaAdresSatir1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaAdresSatir1;
    /**
     * The FaturaAdresSatir2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaAdresSatir2;
    /**
     * The FaturaUnvan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaUnvan;
    /**
     * The IsTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsTel;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The KrediKartiBanka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiBanka;
    /**
     * The KrediKartiCVV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiCVV;
    /**
     * The KrediKartiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiNo;
    /**
     * The KrediKartiSahibi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiSahibi;
    /**
     * The KrediKartiSKTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiSKTar;
    /**
     * The KrediKartiTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KrediKartiTip;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $Sube;
    /**
     * The Unvan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unvan;
    /**
     * The UstCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $UstCari;
    /**
     * The VergiDaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VergiDaire;
    /**
     * The VergiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VergiNo;
    /**
     * The YetkiliKisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YetkiliKisi;
    /**
     * The WebUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebUserName;
    /**
     * The WebPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebPassword;
    /**
     * The DagitimSubesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $DagitimSubesi;
    /**
     * The Sektor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KLookupTablePointer
     */
    public $Sektor;
    /**
     * The GGPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GGPassword;
    /**
     * The VergiDairesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KVergiDairesiPointer
     */
    public $VergiDairesi;
    /**
     * The SegmentKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KLookupTablePointer
     */
    public $SegmentKodu;
    /**
     * The Zimmetli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KPersonelPointer
     */
    public $Zimmetli;
    /**
     * The EvrakKaydetmekIcinYetkiliSubeler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKaydetmekIcinYetkiliSubeler;
    /**
     * The WebServisSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebServisSifre;
    /**
     * The TeslimEdenYetkili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $TeslimEdenYetkili;
    /**
     * The TeslimAlanYetkili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $TeslimAlanYetkili;
    /**
     * The Uyruk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Uyruk;
    /**
     * The Rapor_UstCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Rapor_UstCari;
    /**
     * The CariMailleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfKCariMail
     */
    public $CariMailleri;
    /**
     * The AltSektor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfLong
     */
    public $AltSektor;
    /**
     * The MusteriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriNo;
    /**
     * The BayiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BayiNo;
    /**
     * The PostaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostaKodu;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resim;
    /**
     * The EFaturaCariHesabi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\EFaturaCariHesabi
     */
    public $EFaturaCariHesabi;
    /**
     * Constructor method for KCari
     * @uses KCari::setDurumu()
     * @uses KCari::setHesapBlokToleransGunSayisi()
     * @uses KCari::setHesapKapamaBakiye()
     * @uses KCari::setHesapKapamaDonemi()
     * @uses KCari::setHesapKapamaGunu()
     * @uses KCari::setHesapKapamaMinOdemeTutar()
     * @uses KCari::setHesapTipi()
     * @uses KCari::setIsBlocked()
     * @uses KCari::setIsUstCari()
     * @uses KCari::setOdemeGun()
     * @uses KCari::setOdemeTip()
     * @uses KCari::setOzellik1()
     * @uses KCari::setOzellik2()
     * @uses KCari::setSP_CariMuhasebeHesapSablonuObjId()
     * @uses KCari::setSP_CariObjId()
     * @uses KCari::setSP_MuhasebeKoduObjId()
     * @uses KCari::setSP_OdemePlani()
     * @uses KCari::setTuru()
     * @uses KCari::setUAAliciCariHesapKapamaLimiti()
     * @uses KCari::setUAEvrakLimiti()
     * @uses KCari::setUAGonderenCariLimiti()
     * @uses KCari::setUAGonderiKarsiBakiyeToplami()
     * @uses KCari::setIsWebSatisiVar()
     * @uses KCari::setIsGitGel()
     * @uses KCari::setIsKapidanTahsilat()
     * @uses KCari::setIsCariSozlesmeRaporu()
     * @uses KCari::setPazarlamaciDurumu()
     * @uses KCari::setIsTCCitizen()
     * @uses KCari::setIsIadeOnayVerilsin()
     * @uses KCari::setIsCariKilitli()
     * @uses KCari::setEKargoSmsleGirisOlsunYeni()
     * @uses KCari::setIlceKontroluOlmasin()
     * @uses KCari::setIsPazaryeriMusterisi()
     * @uses KCari::setTeslimatSubeObjId()
     * @uses KCari::setGelenWebCariObjId()
     * @uses KCari::setIsCepTelZorunlu()
     * @uses KCari::setDogumYili()
     * @uses KCari::setAdresi()
     * @uses KCari::setCepTel()
     * @uses KCari::setEmailTeslimat()
     * @uses KCari::setEvTel()
     * @uses KCari::setFaturaAdresSatir1()
     * @uses KCari::setFaturaAdresSatir2()
     * @uses KCari::setFaturaUnvan()
     * @uses KCari::setIsTel()
     * @uses KCari::setKodu()
     * @uses KCari::setKrediKartiBanka()
     * @uses KCari::setKrediKartiCVV()
     * @uses KCari::setKrediKartiNo()
     * @uses KCari::setKrediKartiSahibi()
     * @uses KCari::setKrediKartiSKTar()
     * @uses KCari::setKrediKartiTip()
     * @uses KCari::setSube()
     * @uses KCari::setUnvan()
     * @uses KCari::setUstCari()
     * @uses KCari::setVergiDaire()
     * @uses KCari::setVergiNo()
     * @uses KCari::setYetkiliKisi()
     * @uses KCari::setWebUserName()
     * @uses KCari::setWebPassword()
     * @uses KCari::setDagitimSubesi()
     * @uses KCari::setSektor()
     * @uses KCari::setGGPassword()
     * @uses KCari::setVergiDairesi()
     * @uses KCari::setSegmentKodu()
     * @uses KCari::setZimmetli()
     * @uses KCari::setEvrakKaydetmekIcinYetkiliSubeler()
     * @uses KCari::setWebServisSifre()
     * @uses KCari::setTeslimEdenYetkili()
     * @uses KCari::setTeslimAlanYetkili()
     * @uses KCari::setUyruk()
     * @uses KCari::setRapor_UstCari()
     * @uses KCari::setCariMailleri()
     * @uses KCari::setAltSektor()
     * @uses KCari::setMusteriNo()
     * @uses KCari::setBayiNo()
     * @uses KCari::setPostaKodu()
     * @uses KCari::setResim()
     * @uses KCari::setEFaturaCariHesabi()
     * @param string $durumu
     * @param int $hesapBlokToleransGunSayisi
     * @param float $hesapKapamaBakiye
     * @param string $hesapKapamaDonemi
     * @param string $hesapKapamaGunu
     * @param float $hesapKapamaMinOdemeTutar
     * @param string $hesapTipi
     * @param bool $isBlocked
     * @param bool $isUstCari
     * @param int $odemeGun
     * @param int $odemeTip
     * @param string $ozellik1
     * @param string $ozellik2
     * @param int $sP_CariMuhasebeHesapSablonuObjId
     * @param int $sP_CariObjId
     * @param int $sP_MuhasebeKoduObjId
     * @param int $sP_OdemePlani
     * @param string $turu
     * @param float $uAAliciCariHesapKapamaLimiti
     * @param float $uAEvrakLimiti
     * @param float $uAGonderenCariLimiti
     * @param float $uAGonderiKarsiBakiyeToplami
     * @param bool $isWebSatisiVar
     * @param bool $isGitGel
     * @param bool $isKapidanTahsilat
     * @param bool $isCariSozlesmeRaporu
     * @param string $pazarlamaciDurumu
     * @param bool $isTCCitizen
     * @param bool $isIadeOnayVerilsin
     * @param bool $isCariKilitli
     * @param bool $eKargoSmsleGirisOlsunYeni
     * @param bool $ilceKontroluOlmasin
     * @param bool $isPazaryeriMusterisi
     * @param int $teslimatSubeObjId
     * @param int $gelenWebCariObjId
     * @param bool $isCepTelZorunlu
     * @param int $dogumYili
     * @param \fk_\StructType\KAdresPointer $adresi
     * @param string $cepTel
     * @param string $emailTeslimat
     * @param string $evTel
     * @param string $faturaAdresSatir1
     * @param string $faturaAdresSatir2
     * @param string $faturaUnvan
     * @param string $isTel
     * @param string $kodu
     * @param string $krediKartiBanka
     * @param string $krediKartiCVV
     * @param string $krediKartiNo
     * @param string $krediKartiSahibi
     * @param string $krediKartiSKTar
     * @param string $krediKartiTip
     * @param \fk_\StructType\KSubePointer $sube
     * @param string $unvan
     * @param \fk_\StructType\KCariPointer $ustCari
     * @param string $vergiDaire
     * @param string $vergiNo
     * @param string $yetkiliKisi
     * @param string $webUserName
     * @param string $webPassword
     * @param \fk_\StructType\KSubePointer $dagitimSubesi
     * @param \fk_\StructType\KLookupTablePointer $sektor
     * @param string $gGPassword
     * @param \fk_\StructType\KVergiDairesiPointer $vergiDairesi
     * @param \fk_\StructType\KLookupTablePointer $segmentKodu
     * @param \fk_\StructType\KPersonelPointer $zimmetli
     * @param string $evrakKaydetmekIcinYetkiliSubeler
     * @param string $webServisSifre
     * @param \fk_\StructType\KCariPointer $teslimEdenYetkili
     * @param \fk_\StructType\KCariPointer $teslimAlanYetkili
     * @param string $uyruk
     * @param \fk_\StructType\KCariPointer $rapor_UstCari
     * @param \fk_\ArrayType\ArrayOfKCariMail $cariMailleri
     * @param \fk_\ArrayType\ArrayOfLong $altSektor
     * @param string $musteriNo
     * @param string $bayiNo
     * @param string $postaKodu
     * @param string $resim
     * @param \fk_\StructType\EFaturaCariHesabi $eFaturaCariHesabi
     */
    public function __construct($durumu = null, $hesapBlokToleransGunSayisi = null, $hesapKapamaBakiye = null, $hesapKapamaDonemi = null, $hesapKapamaGunu = null, $hesapKapamaMinOdemeTutar = null, $hesapTipi = null, $isBlocked = null, $isUstCari = null, $odemeGun = null, $odemeTip = null, $ozellik1 = null, $ozellik2 = null, $sP_CariMuhasebeHesapSablonuObjId = null, $sP_CariObjId = null, $sP_MuhasebeKoduObjId = null, $sP_OdemePlani = null, $turu = null, $uAAliciCariHesapKapamaLimiti = null, $uAEvrakLimiti = null, $uAGonderenCariLimiti = null, $uAGonderiKarsiBakiyeToplami = null, $isWebSatisiVar = null, $isGitGel = null, $isKapidanTahsilat = null, $isCariSozlesmeRaporu = null, $pazarlamaciDurumu = null, $isTCCitizen = null, $isIadeOnayVerilsin = null, $isCariKilitli = null, $eKargoSmsleGirisOlsunYeni = null, $ilceKontroluOlmasin = null, $isPazaryeriMusterisi = null, $teslimatSubeObjId = null, $gelenWebCariObjId = null, $isCepTelZorunlu = null, $dogumYili = null, \fk_\StructType\KAdresPointer $adresi = null, $cepTel = null, $emailTeslimat = null, $evTel = null, $faturaAdresSatir1 = null, $faturaAdresSatir2 = null, $faturaUnvan = null, $isTel = null, $kodu = null, $krediKartiBanka = null, $krediKartiCVV = null, $krediKartiNo = null, $krediKartiSahibi = null, $krediKartiSKTar = null, $krediKartiTip = null, \fk_\StructType\KSubePointer $sube = null, $unvan = null, \fk_\StructType\KCariPointer $ustCari = null, $vergiDaire = null, $vergiNo = null, $yetkiliKisi = null, $webUserName = null, $webPassword = null, \fk_\StructType\KSubePointer $dagitimSubesi = null, \fk_\StructType\KLookupTablePointer $sektor = null, $gGPassword = null, \fk_\StructType\KVergiDairesiPointer $vergiDairesi = null, \fk_\StructType\KLookupTablePointer $segmentKodu = null, \fk_\StructType\KPersonelPointer $zimmetli = null, $evrakKaydetmekIcinYetkiliSubeler = null, $webServisSifre = null, \fk_\StructType\KCariPointer $teslimEdenYetkili = null, \fk_\StructType\KCariPointer $teslimAlanYetkili = null, $uyruk = null, \fk_\StructType\KCariPointer $rapor_UstCari = null, \fk_\ArrayType\ArrayOfKCariMail $cariMailleri = null, \fk_\ArrayType\ArrayOfLong $altSektor = null, $musteriNo = null, $bayiNo = null, $postaKodu = null, $resim = null, \fk_\StructType\EFaturaCariHesabi $eFaturaCariHesabi = null)
    {
        $this
            ->setDurumu($durumu)
            ->setHesapBlokToleransGunSayisi($hesapBlokToleransGunSayisi)
            ->setHesapKapamaBakiye($hesapKapamaBakiye)
            ->setHesapKapamaDonemi($hesapKapamaDonemi)
            ->setHesapKapamaGunu($hesapKapamaGunu)
            ->setHesapKapamaMinOdemeTutar($hesapKapamaMinOdemeTutar)
            ->setHesapTipi($hesapTipi)
            ->setIsBlocked($isBlocked)
            ->setIsUstCari($isUstCari)
            ->setOdemeGun($odemeGun)
            ->setOdemeTip($odemeTip)
            ->setOzellik1($ozellik1)
            ->setOzellik2($ozellik2)
            ->setSP_CariMuhasebeHesapSablonuObjId($sP_CariMuhasebeHesapSablonuObjId)
            ->setSP_CariObjId($sP_CariObjId)
            ->setSP_MuhasebeKoduObjId($sP_MuhasebeKoduObjId)
            ->setSP_OdemePlani($sP_OdemePlani)
            ->setTuru($turu)
            ->setUAAliciCariHesapKapamaLimiti($uAAliciCariHesapKapamaLimiti)
            ->setUAEvrakLimiti($uAEvrakLimiti)
            ->setUAGonderenCariLimiti($uAGonderenCariLimiti)
            ->setUAGonderiKarsiBakiyeToplami($uAGonderiKarsiBakiyeToplami)
            ->setIsWebSatisiVar($isWebSatisiVar)
            ->setIsGitGel($isGitGel)
            ->setIsKapidanTahsilat($isKapidanTahsilat)
            ->setIsCariSozlesmeRaporu($isCariSozlesmeRaporu)
            ->setPazarlamaciDurumu($pazarlamaciDurumu)
            ->setIsTCCitizen($isTCCitizen)
            ->setIsIadeOnayVerilsin($isIadeOnayVerilsin)
            ->setIsCariKilitli($isCariKilitli)
            ->setEKargoSmsleGirisOlsunYeni($eKargoSmsleGirisOlsunYeni)
            ->setIlceKontroluOlmasin($ilceKontroluOlmasin)
            ->setIsPazaryeriMusterisi($isPazaryeriMusterisi)
            ->setTeslimatSubeObjId($teslimatSubeObjId)
            ->setGelenWebCariObjId($gelenWebCariObjId)
            ->setIsCepTelZorunlu($isCepTelZorunlu)
            ->setDogumYili($dogumYili)
            ->setAdresi($adresi)
            ->setCepTel($cepTel)
            ->setEmailTeslimat($emailTeslimat)
            ->setEvTel($evTel)
            ->setFaturaAdresSatir1($faturaAdresSatir1)
            ->setFaturaAdresSatir2($faturaAdresSatir2)
            ->setFaturaUnvan($faturaUnvan)
            ->setIsTel($isTel)
            ->setKodu($kodu)
            ->setKrediKartiBanka($krediKartiBanka)
            ->setKrediKartiCVV($krediKartiCVV)
            ->setKrediKartiNo($krediKartiNo)
            ->setKrediKartiSahibi($krediKartiSahibi)
            ->setKrediKartiSKTar($krediKartiSKTar)
            ->setKrediKartiTip($krediKartiTip)
            ->setSube($sube)
            ->setUnvan($unvan)
            ->setUstCari($ustCari)
            ->setVergiDaire($vergiDaire)
            ->setVergiNo($vergiNo)
            ->setYetkiliKisi($yetkiliKisi)
            ->setWebUserName($webUserName)
            ->setWebPassword($webPassword)
            ->setDagitimSubesi($dagitimSubesi)
            ->setSektor($sektor)
            ->setGGPassword($gGPassword)
            ->setVergiDairesi($vergiDairesi)
            ->setSegmentKodu($segmentKodu)
            ->setZimmetli($zimmetli)
            ->setEvrakKaydetmekIcinYetkiliSubeler($evrakKaydetmekIcinYetkiliSubeler)
            ->setWebServisSifre($webServisSifre)
            ->setTeslimEdenYetkili($teslimEdenYetkili)
            ->setTeslimAlanYetkili($teslimAlanYetkili)
            ->setUyruk($uyruk)
            ->setRapor_UstCari($rapor_UstCari)
            ->setCariMailleri($cariMailleri)
            ->setAltSektor($altSektor)
            ->setMusteriNo($musteriNo)
            ->setBayiNo($bayiNo)
            ->setPostaKodu($postaKodu)
            ->setResim($resim)
            ->setEFaturaCariHesabi($eFaturaCariHesabi);
    }
    /**
     * Get Durumu value
     * @return string
     */
    public function getDurumu()
    {
        return $this->Durumu;
    }
    /**
     * Set Durumu value
     * @uses \fk_\EnumType\CariHesapDurum::valueIsValid()
     * @uses \fk_\EnumType\CariHesapDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durumu
     * @return \fk_\StructType\KCari
     */
    public function setDurumu($durumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\CariHesapDurum::valueIsValid($durumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\CariHesapDurum', is_array($durumu) ? implode(', ', $durumu) : var_export($durumu, true), implode(', ', \fk_\EnumType\CariHesapDurum::getValidValues())), __LINE__);
        }
        $this->Durumu = $durumu;
        return $this;
    }
    /**
     * Get HesapBlokToleransGunSayisi value
     * @return int
     */
    public function getHesapBlokToleransGunSayisi()
    {
        return $this->HesapBlokToleransGunSayisi;
    }
    /**
     * Set HesapBlokToleransGunSayisi value
     * @param int $hesapBlokToleransGunSayisi
     * @return \fk_\StructType\KCari
     */
    public function setHesapBlokToleransGunSayisi($hesapBlokToleransGunSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($hesapBlokToleransGunSayisi) && !(is_int($hesapBlokToleransGunSayisi) || ctype_digit($hesapBlokToleransGunSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hesapBlokToleransGunSayisi, true), gettype($hesapBlokToleransGunSayisi)), __LINE__);
        }
        $this->HesapBlokToleransGunSayisi = $hesapBlokToleransGunSayisi;
        return $this;
    }
    /**
     * Get HesapKapamaBakiye value
     * @return float
     */
    public function getHesapKapamaBakiye()
    {
        return $this->HesapKapamaBakiye;
    }
    /**
     * Set HesapKapamaBakiye value
     * @param float $hesapKapamaBakiye
     * @return \fk_\StructType\KCari
     */
    public function setHesapKapamaBakiye($hesapKapamaBakiye = null)
    {
        // validation for constraint: float
        if (!is_null($hesapKapamaBakiye) && !(is_float($hesapKapamaBakiye) || is_numeric($hesapKapamaBakiye))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hesapKapamaBakiye, true), gettype($hesapKapamaBakiye)), __LINE__);
        }
        $this->HesapKapamaBakiye = $hesapKapamaBakiye;
        return $this;
    }
    /**
     * Get HesapKapamaDonemi value
     * @return string
     */
    public function getHesapKapamaDonemi()
    {
        return $this->HesapKapamaDonemi;
    }
    /**
     * Set HesapKapamaDonemi value
     * @uses \fk_\EnumType\KIslemPeriodu::valueIsValid()
     * @uses \fk_\EnumType\KIslemPeriodu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hesapKapamaDonemi
     * @return \fk_\StructType\KCari
     */
    public function setHesapKapamaDonemi($hesapKapamaDonemi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KIslemPeriodu::valueIsValid($hesapKapamaDonemi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KIslemPeriodu', is_array($hesapKapamaDonemi) ? implode(', ', $hesapKapamaDonemi) : var_export($hesapKapamaDonemi, true), implode(', ', \fk_\EnumType\KIslemPeriodu::getValidValues())), __LINE__);
        }
        $this->HesapKapamaDonemi = $hesapKapamaDonemi;
        return $this;
    }
    /**
     * Get HesapKapamaGunu value
     * @return string
     */
    public function getHesapKapamaGunu()
    {
        return $this->HesapKapamaGunu;
    }
    /**
     * Set HesapKapamaGunu value
     * @uses \fk_\EnumType\KGunler::valueIsValid()
     * @uses \fk_\EnumType\KGunler::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hesapKapamaGunu
     * @return \fk_\StructType\KCari
     */
    public function setHesapKapamaGunu($hesapKapamaGunu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KGunler::valueIsValid($hesapKapamaGunu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KGunler', is_array($hesapKapamaGunu) ? implode(', ', $hesapKapamaGunu) : var_export($hesapKapamaGunu, true), implode(', ', \fk_\EnumType\KGunler::getValidValues())), __LINE__);
        }
        $this->HesapKapamaGunu = $hesapKapamaGunu;
        return $this;
    }
    /**
     * Get HesapKapamaMinOdemeTutar value
     * @return float
     */
    public function getHesapKapamaMinOdemeTutar()
    {
        return $this->HesapKapamaMinOdemeTutar;
    }
    /**
     * Set HesapKapamaMinOdemeTutar value
     * @param float $hesapKapamaMinOdemeTutar
     * @return \fk_\StructType\KCari
     */
    public function setHesapKapamaMinOdemeTutar($hesapKapamaMinOdemeTutar = null)
    {
        // validation for constraint: float
        if (!is_null($hesapKapamaMinOdemeTutar) && !(is_float($hesapKapamaMinOdemeTutar) || is_numeric($hesapKapamaMinOdemeTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hesapKapamaMinOdemeTutar, true), gettype($hesapKapamaMinOdemeTutar)), __LINE__);
        }
        $this->HesapKapamaMinOdemeTutar = $hesapKapamaMinOdemeTutar;
        return $this;
    }
    /**
     * Get HesapTipi value
     * @return string
     */
    public function getHesapTipi()
    {
        return $this->HesapTipi;
    }
    /**
     * Set HesapTipi value
     * @uses \fk_\EnumType\CariHesapTipi::valueIsValid()
     * @uses \fk_\EnumType\CariHesapTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hesapTipi
     * @return \fk_\StructType\KCari
     */
    public function setHesapTipi($hesapTipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\CariHesapTipi::valueIsValid($hesapTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\CariHesapTipi', is_array($hesapTipi) ? implode(', ', $hesapTipi) : var_export($hesapTipi, true), implode(', ', \fk_\EnumType\CariHesapTipi::getValidValues())), __LINE__);
        }
        $this->HesapTipi = $hesapTipi;
        return $this;
    }
    /**
     * Get IsBlocked value
     * @return bool
     */
    public function getIsBlocked()
    {
        return $this->IsBlocked;
    }
    /**
     * Set IsBlocked value
     * @param bool $isBlocked
     * @return \fk_\StructType\KCari
     */
    public function setIsBlocked($isBlocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBlocked) && !is_bool($isBlocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBlocked, true), gettype($isBlocked)), __LINE__);
        }
        $this->IsBlocked = $isBlocked;
        return $this;
    }
    /**
     * Get IsUstCari value
     * @return bool
     */
    public function getIsUstCari()
    {
        return $this->IsUstCari;
    }
    /**
     * Set IsUstCari value
     * @param bool $isUstCari
     * @return \fk_\StructType\KCari
     */
    public function setIsUstCari($isUstCari = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUstCari) && !is_bool($isUstCari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUstCari, true), gettype($isUstCari)), __LINE__);
        }
        $this->IsUstCari = $isUstCari;
        return $this;
    }
    /**
     * Get OdemeGun value
     * @return int
     */
    public function getOdemeGun()
    {
        return $this->OdemeGun;
    }
    /**
     * Set OdemeGun value
     * @param int $odemeGun
     * @return \fk_\StructType\KCari
     */
    public function setOdemeGun($odemeGun = null)
    {
        // validation for constraint: int
        if (!is_null($odemeGun) && !(is_int($odemeGun) || ctype_digit($odemeGun))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeGun, true), gettype($odemeGun)), __LINE__);
        }
        $this->OdemeGun = $odemeGun;
        return $this;
    }
    /**
     * Get OdemeTip value
     * @return int
     */
    public function getOdemeTip()
    {
        return $this->OdemeTip;
    }
    /**
     * Set OdemeTip value
     * @param int $odemeTip
     * @return \fk_\StructType\KCari
     */
    public function setOdemeTip($odemeTip = null)
    {
        // validation for constraint: int
        if (!is_null($odemeTip) && !(is_int($odemeTip) || ctype_digit($odemeTip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeTip, true), gettype($odemeTip)), __LINE__);
        }
        $this->OdemeTip = $odemeTip;
        return $this;
    }
    /**
     * Get Ozellik1 value
     * @return string
     */
    public function getOzellik1()
    {
        return $this->Ozellik1;
    }
    /**
     * Set Ozellik1 value
     * @uses \fk_\EnumType\CariOzellik::valueIsValid()
     * @uses \fk_\EnumType\CariOzellik::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ozellik1
     * @return \fk_\StructType\KCari
     */
    public function setOzellik1($ozellik1 = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\CariOzellik::valueIsValid($ozellik1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\CariOzellik', is_array($ozellik1) ? implode(', ', $ozellik1) : var_export($ozellik1, true), implode(', ', \fk_\EnumType\CariOzellik::getValidValues())), __LINE__);
        }
        $this->Ozellik1 = $ozellik1;
        return $this;
    }
    /**
     * Get Ozellik2 value
     * @return string
     */
    public function getOzellik2()
    {
        return $this->Ozellik2;
    }
    /**
     * Set Ozellik2 value
     * @uses \fk_\EnumType\KCariOzellik::valueIsValid()
     * @uses \fk_\EnumType\KCariOzellik::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ozellik2
     * @return \fk_\StructType\KCari
     */
    public function setOzellik2($ozellik2 = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KCariOzellik::valueIsValid($ozellik2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KCariOzellik', is_array($ozellik2) ? implode(', ', $ozellik2) : var_export($ozellik2, true), implode(', ', \fk_\EnumType\KCariOzellik::getValidValues())), __LINE__);
        }
        $this->Ozellik2 = $ozellik2;
        return $this;
    }
    /**
     * Get SP_CariMuhasebeHesapSablonuObjId value
     * @return int
     */
    public function getSP_CariMuhasebeHesapSablonuObjId()
    {
        return $this->SP_CariMuhasebeHesapSablonuObjId;
    }
    /**
     * Set SP_CariMuhasebeHesapSablonuObjId value
     * @param int $sP_CariMuhasebeHesapSablonuObjId
     * @return \fk_\StructType\KCari
     */
    public function setSP_CariMuhasebeHesapSablonuObjId($sP_CariMuhasebeHesapSablonuObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_CariMuhasebeHesapSablonuObjId) && !(is_int($sP_CariMuhasebeHesapSablonuObjId) || ctype_digit($sP_CariMuhasebeHesapSablonuObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_CariMuhasebeHesapSablonuObjId, true), gettype($sP_CariMuhasebeHesapSablonuObjId)), __LINE__);
        }
        $this->SP_CariMuhasebeHesapSablonuObjId = $sP_CariMuhasebeHesapSablonuObjId;
        return $this;
    }
    /**
     * Get SP_CariObjId value
     * @return int
     */
    public function getSP_CariObjId()
    {
        return $this->SP_CariObjId;
    }
    /**
     * Set SP_CariObjId value
     * @param int $sP_CariObjId
     * @return \fk_\StructType\KCari
     */
    public function setSP_CariObjId($sP_CariObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_CariObjId) && !(is_int($sP_CariObjId) || ctype_digit($sP_CariObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_CariObjId, true), gettype($sP_CariObjId)), __LINE__);
        }
        $this->SP_CariObjId = $sP_CariObjId;
        return $this;
    }
    /**
     * Get SP_MuhasebeKoduObjId value
     * @return int
     */
    public function getSP_MuhasebeKoduObjId()
    {
        return $this->SP_MuhasebeKoduObjId;
    }
    /**
     * Set SP_MuhasebeKoduObjId value
     * @param int $sP_MuhasebeKoduObjId
     * @return \fk_\StructType\KCari
     */
    public function setSP_MuhasebeKoduObjId($sP_MuhasebeKoduObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_MuhasebeKoduObjId) && !(is_int($sP_MuhasebeKoduObjId) || ctype_digit($sP_MuhasebeKoduObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_MuhasebeKoduObjId, true), gettype($sP_MuhasebeKoduObjId)), __LINE__);
        }
        $this->SP_MuhasebeKoduObjId = $sP_MuhasebeKoduObjId;
        return $this;
    }
    /**
     * Get SP_OdemePlani value
     * @return int
     */
    public function getSP_OdemePlani()
    {
        return $this->SP_OdemePlani;
    }
    /**
     * Set SP_OdemePlani value
     * @param int $sP_OdemePlani
     * @return \fk_\StructType\KCari
     */
    public function setSP_OdemePlani($sP_OdemePlani = null)
    {
        // validation for constraint: int
        if (!is_null($sP_OdemePlani) && !(is_int($sP_OdemePlani) || ctype_digit($sP_OdemePlani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_OdemePlani, true), gettype($sP_OdemePlani)), __LINE__);
        }
        $this->SP_OdemePlani = $sP_OdemePlani;
        return $this;
    }
    /**
     * Get Turu value
     * @return string
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @uses \fk_\EnumType\CariHesapTuru::valueIsValid()
     * @uses \fk_\EnumType\CariHesapTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $turu
     * @return \fk_\StructType\KCari
     */
    public function setTuru($turu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\CariHesapTuru::valueIsValid($turu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\CariHesapTuru', is_array($turu) ? implode(', ', $turu) : var_export($turu, true), implode(', ', \fk_\EnumType\CariHesapTuru::getValidValues())), __LINE__);
        }
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get UAAliciCariHesapKapamaLimiti value
     * @return float
     */
    public function getUAAliciCariHesapKapamaLimiti()
    {
        return $this->UAAliciCariHesapKapamaLimiti;
    }
    /**
     * Set UAAliciCariHesapKapamaLimiti value
     * @param float $uAAliciCariHesapKapamaLimiti
     * @return \fk_\StructType\KCari
     */
    public function setUAAliciCariHesapKapamaLimiti($uAAliciCariHesapKapamaLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($uAAliciCariHesapKapamaLimiti) && !(is_float($uAAliciCariHesapKapamaLimiti) || is_numeric($uAAliciCariHesapKapamaLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uAAliciCariHesapKapamaLimiti, true), gettype($uAAliciCariHesapKapamaLimiti)), __LINE__);
        }
        $this->UAAliciCariHesapKapamaLimiti = $uAAliciCariHesapKapamaLimiti;
        return $this;
    }
    /**
     * Get UAEvrakLimiti value
     * @return float
     */
    public function getUAEvrakLimiti()
    {
        return $this->UAEvrakLimiti;
    }
    /**
     * Set UAEvrakLimiti value
     * @param float $uAEvrakLimiti
     * @return \fk_\StructType\KCari
     */
    public function setUAEvrakLimiti($uAEvrakLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($uAEvrakLimiti) && !(is_float($uAEvrakLimiti) || is_numeric($uAEvrakLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uAEvrakLimiti, true), gettype($uAEvrakLimiti)), __LINE__);
        }
        $this->UAEvrakLimiti = $uAEvrakLimiti;
        return $this;
    }
    /**
     * Get UAGonderenCariLimiti value
     * @return float
     */
    public function getUAGonderenCariLimiti()
    {
        return $this->UAGonderenCariLimiti;
    }
    /**
     * Set UAGonderenCariLimiti value
     * @param float $uAGonderenCariLimiti
     * @return \fk_\StructType\KCari
     */
    public function setUAGonderenCariLimiti($uAGonderenCariLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($uAGonderenCariLimiti) && !(is_float($uAGonderenCariLimiti) || is_numeric($uAGonderenCariLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uAGonderenCariLimiti, true), gettype($uAGonderenCariLimiti)), __LINE__);
        }
        $this->UAGonderenCariLimiti = $uAGonderenCariLimiti;
        return $this;
    }
    /**
     * Get UAGonderiKarsiBakiyeToplami value
     * @return float
     */
    public function getUAGonderiKarsiBakiyeToplami()
    {
        return $this->UAGonderiKarsiBakiyeToplami;
    }
    /**
     * Set UAGonderiKarsiBakiyeToplami value
     * @param float $uAGonderiKarsiBakiyeToplami
     * @return \fk_\StructType\KCari
     */
    public function setUAGonderiKarsiBakiyeToplami($uAGonderiKarsiBakiyeToplami = null)
    {
        // validation for constraint: float
        if (!is_null($uAGonderiKarsiBakiyeToplami) && !(is_float($uAGonderiKarsiBakiyeToplami) || is_numeric($uAGonderiKarsiBakiyeToplami))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uAGonderiKarsiBakiyeToplami, true), gettype($uAGonderiKarsiBakiyeToplami)), __LINE__);
        }
        $this->UAGonderiKarsiBakiyeToplami = $uAGonderiKarsiBakiyeToplami;
        return $this;
    }
    /**
     * Get IsWebSatisiVar value
     * @return bool
     */
    public function getIsWebSatisiVar()
    {
        return $this->IsWebSatisiVar;
    }
    /**
     * Set IsWebSatisiVar value
     * @param bool $isWebSatisiVar
     * @return \fk_\StructType\KCari
     */
    public function setIsWebSatisiVar($isWebSatisiVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWebSatisiVar) && !is_bool($isWebSatisiVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWebSatisiVar, true), gettype($isWebSatisiVar)), __LINE__);
        }
        $this->IsWebSatisiVar = $isWebSatisiVar;
        return $this;
    }
    /**
     * Get IsGitGel value
     * @return bool
     */
    public function getIsGitGel()
    {
        return $this->IsGitGel;
    }
    /**
     * Set IsGitGel value
     * @param bool $isGitGel
     * @return \fk_\StructType\KCari
     */
    public function setIsGitGel($isGitGel = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGitGel) && !is_bool($isGitGel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGitGel, true), gettype($isGitGel)), __LINE__);
        }
        $this->IsGitGel = $isGitGel;
        return $this;
    }
    /**
     * Get IsKapidanTahsilat value
     * @return bool
     */
    public function getIsKapidanTahsilat()
    {
        return $this->IsKapidanTahsilat;
    }
    /**
     * Set IsKapidanTahsilat value
     * @param bool $isKapidanTahsilat
     * @return \fk_\StructType\KCari
     */
    public function setIsKapidanTahsilat($isKapidanTahsilat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKapidanTahsilat) && !is_bool($isKapidanTahsilat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKapidanTahsilat, true), gettype($isKapidanTahsilat)), __LINE__);
        }
        $this->IsKapidanTahsilat = $isKapidanTahsilat;
        return $this;
    }
    /**
     * Get IsCariSozlesmeRaporu value
     * @return bool
     */
    public function getIsCariSozlesmeRaporu()
    {
        return $this->IsCariSozlesmeRaporu;
    }
    /**
     * Set IsCariSozlesmeRaporu value
     * @param bool $isCariSozlesmeRaporu
     * @return \fk_\StructType\KCari
     */
    public function setIsCariSozlesmeRaporu($isCariSozlesmeRaporu = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCariSozlesmeRaporu) && !is_bool($isCariSozlesmeRaporu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCariSozlesmeRaporu, true), gettype($isCariSozlesmeRaporu)), __LINE__);
        }
        $this->IsCariSozlesmeRaporu = $isCariSozlesmeRaporu;
        return $this;
    }
    /**
     * Get PazarlamaciDurumu value
     * @return string
     */
    public function getPazarlamaciDurumu()
    {
        return $this->PazarlamaciDurumu;
    }
    /**
     * Set PazarlamaciDurumu value
     * @uses \fk_\EnumType\PazarlamaciDurumu::valueIsValid()
     * @uses \fk_\EnumType\PazarlamaciDurumu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pazarlamaciDurumu
     * @return \fk_\StructType\KCari
     */
    public function setPazarlamaciDurumu($pazarlamaciDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\PazarlamaciDurumu::valueIsValid($pazarlamaciDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\PazarlamaciDurumu', is_array($pazarlamaciDurumu) ? implode(', ', $pazarlamaciDurumu) : var_export($pazarlamaciDurumu, true), implode(', ', \fk_\EnumType\PazarlamaciDurumu::getValidValues())), __LINE__);
        }
        $this->PazarlamaciDurumu = $pazarlamaciDurumu;
        return $this;
    }
    /**
     * Get isTCCitizen value
     * @return bool
     */
    public function getIsTCCitizen()
    {
        return $this->isTCCitizen;
    }
    /**
     * Set isTCCitizen value
     * @param bool $isTCCitizen
     * @return \fk_\StructType\KCari
     */
    public function setIsTCCitizen($isTCCitizen = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTCCitizen) && !is_bool($isTCCitizen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTCCitizen, true), gettype($isTCCitizen)), __LINE__);
        }
        $this->isTCCitizen = $isTCCitizen;
        return $this;
    }
    /**
     * Get IsIadeOnayVerilsin value
     * @return bool
     */
    public function getIsIadeOnayVerilsin()
    {
        return $this->IsIadeOnayVerilsin;
    }
    /**
     * Set IsIadeOnayVerilsin value
     * @param bool $isIadeOnayVerilsin
     * @return \fk_\StructType\KCari
     */
    public function setIsIadeOnayVerilsin($isIadeOnayVerilsin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIadeOnayVerilsin) && !is_bool($isIadeOnayVerilsin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIadeOnayVerilsin, true), gettype($isIadeOnayVerilsin)), __LINE__);
        }
        $this->IsIadeOnayVerilsin = $isIadeOnayVerilsin;
        return $this;
    }
    /**
     * Get IsCariKilitli value
     * @return bool
     */
    public function getIsCariKilitli()
    {
        return $this->IsCariKilitli;
    }
    /**
     * Set IsCariKilitli value
     * @param bool $isCariKilitli
     * @return \fk_\StructType\KCari
     */
    public function setIsCariKilitli($isCariKilitli = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCariKilitli) && !is_bool($isCariKilitli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCariKilitli, true), gettype($isCariKilitli)), __LINE__);
        }
        $this->IsCariKilitli = $isCariKilitli;
        return $this;
    }
    /**
     * Get EKargoSmsleGirisOlsunYeni value
     * @return bool
     */
    public function getEKargoSmsleGirisOlsunYeni()
    {
        return $this->EKargoSmsleGirisOlsunYeni;
    }
    /**
     * Set EKargoSmsleGirisOlsunYeni value
     * @param bool $eKargoSmsleGirisOlsunYeni
     * @return \fk_\StructType\KCari
     */
    public function setEKargoSmsleGirisOlsunYeni($eKargoSmsleGirisOlsunYeni = null)
    {
        // validation for constraint: boolean
        if (!is_null($eKargoSmsleGirisOlsunYeni) && !is_bool($eKargoSmsleGirisOlsunYeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eKargoSmsleGirisOlsunYeni, true), gettype($eKargoSmsleGirisOlsunYeni)), __LINE__);
        }
        $this->EKargoSmsleGirisOlsunYeni = $eKargoSmsleGirisOlsunYeni;
        return $this;
    }
    /**
     * Get IlceKontroluOlmasin value
     * @return bool
     */
    public function getIlceKontroluOlmasin()
    {
        return $this->IlceKontroluOlmasin;
    }
    /**
     * Set IlceKontroluOlmasin value
     * @param bool $ilceKontroluOlmasin
     * @return \fk_\StructType\KCari
     */
    public function setIlceKontroluOlmasin($ilceKontroluOlmasin = null)
    {
        // validation for constraint: boolean
        if (!is_null($ilceKontroluOlmasin) && !is_bool($ilceKontroluOlmasin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ilceKontroluOlmasin, true), gettype($ilceKontroluOlmasin)), __LINE__);
        }
        $this->IlceKontroluOlmasin = $ilceKontroluOlmasin;
        return $this;
    }
    /**
     * Get IsPazaryeriMusterisi value
     * @return bool
     */
    public function getIsPazaryeriMusterisi()
    {
        return $this->IsPazaryeriMusterisi;
    }
    /**
     * Set IsPazaryeriMusterisi value
     * @param bool $isPazaryeriMusterisi
     * @return \fk_\StructType\KCari
     */
    public function setIsPazaryeriMusterisi($isPazaryeriMusterisi = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPazaryeriMusterisi) && !is_bool($isPazaryeriMusterisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPazaryeriMusterisi, true), gettype($isPazaryeriMusterisi)), __LINE__);
        }
        $this->IsPazaryeriMusterisi = $isPazaryeriMusterisi;
        return $this;
    }
    /**
     * Get TeslimatSubeObjId value
     * @return int
     */
    public function getTeslimatSubeObjId()
    {
        return $this->TeslimatSubeObjId;
    }
    /**
     * Set TeslimatSubeObjId value
     * @param int $teslimatSubeObjId
     * @return \fk_\StructType\KCari
     */
    public function setTeslimatSubeObjId($teslimatSubeObjId = null)
    {
        // validation for constraint: int
        if (!is_null($teslimatSubeObjId) && !(is_int($teslimatSubeObjId) || ctype_digit($teslimatSubeObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($teslimatSubeObjId, true), gettype($teslimatSubeObjId)), __LINE__);
        }
        $this->TeslimatSubeObjId = $teslimatSubeObjId;
        return $this;
    }
    /**
     * Get GelenWebCariObjId value
     * @return int
     */
    public function getGelenWebCariObjId()
    {
        return $this->GelenWebCariObjId;
    }
    /**
     * Set GelenWebCariObjId value
     * @param int $gelenWebCariObjId
     * @return \fk_\StructType\KCari
     */
    public function setGelenWebCariObjId($gelenWebCariObjId = null)
    {
        // validation for constraint: int
        if (!is_null($gelenWebCariObjId) && !(is_int($gelenWebCariObjId) || ctype_digit($gelenWebCariObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gelenWebCariObjId, true), gettype($gelenWebCariObjId)), __LINE__);
        }
        $this->GelenWebCariObjId = $gelenWebCariObjId;
        return $this;
    }
    /**
     * Get IsCepTelZorunlu value
     * @return bool
     */
    public function getIsCepTelZorunlu()
    {
        return $this->IsCepTelZorunlu;
    }
    /**
     * Set IsCepTelZorunlu value
     * @param bool $isCepTelZorunlu
     * @return \fk_\StructType\KCari
     */
    public function setIsCepTelZorunlu($isCepTelZorunlu = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCepTelZorunlu) && !is_bool($isCepTelZorunlu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCepTelZorunlu, true), gettype($isCepTelZorunlu)), __LINE__);
        }
        $this->IsCepTelZorunlu = $isCepTelZorunlu;
        return $this;
    }
    /**
     * Get DogumYili value
     * @return int
     */
    public function getDogumYili()
    {
        return $this->DogumYili;
    }
    /**
     * Set DogumYili value
     * @param int $dogumYili
     * @return \fk_\StructType\KCari
     */
    public function setDogumYili($dogumYili = null)
    {
        // validation for constraint: int
        if (!is_null($dogumYili) && !(is_int($dogumYili) || ctype_digit($dogumYili))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dogumYili, true), gettype($dogumYili)), __LINE__);
        }
        $this->DogumYili = $dogumYili;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \fk_\StructType\KAdresPointer|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \fk_\StructType\KAdresPointer $adresi
     * @return \fk_\StructType\KCari
     */
    public function setAdresi(\fk_\StructType\KAdresPointer $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get CepTel value
     * @return string|null
     */
    public function getCepTel()
    {
        return $this->CepTel;
    }
    /**
     * Set CepTel value
     * @param string $cepTel
     * @return \fk_\StructType\KCari
     */
    public function setCepTel($cepTel = null)
    {
        // validation for constraint: string
        if (!is_null($cepTel) && !is_string($cepTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cepTel, true), gettype($cepTel)), __LINE__);
        }
        $this->CepTel = $cepTel;
        return $this;
    }
    /**
     * Get EmailTeslimat value
     * @return string|null
     */
    public function getEmailTeslimat()
    {
        return $this->EmailTeslimat;
    }
    /**
     * Set EmailTeslimat value
     * @param string $emailTeslimat
     * @return \fk_\StructType\KCari
     */
    public function setEmailTeslimat($emailTeslimat = null)
    {
        // validation for constraint: string
        if (!is_null($emailTeslimat) && !is_string($emailTeslimat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTeslimat, true), gettype($emailTeslimat)), __LINE__);
        }
        $this->EmailTeslimat = $emailTeslimat;
        return $this;
    }
    /**
     * Get EvTel value
     * @return string|null
     */
    public function getEvTel()
    {
        return $this->EvTel;
    }
    /**
     * Set EvTel value
     * @param string $evTel
     * @return \fk_\StructType\KCari
     */
    public function setEvTel($evTel = null)
    {
        // validation for constraint: string
        if (!is_null($evTel) && !is_string($evTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evTel, true), gettype($evTel)), __LINE__);
        }
        $this->EvTel = $evTel;
        return $this;
    }
    /**
     * Get FaturaAdresSatir1 value
     * @return string|null
     */
    public function getFaturaAdresSatir1()
    {
        return $this->FaturaAdresSatir1;
    }
    /**
     * Set FaturaAdresSatir1 value
     * @param string $faturaAdresSatir1
     * @return \fk_\StructType\KCari
     */
    public function setFaturaAdresSatir1($faturaAdresSatir1 = null)
    {
        // validation for constraint: string
        if (!is_null($faturaAdresSatir1) && !is_string($faturaAdresSatir1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaAdresSatir1, true), gettype($faturaAdresSatir1)), __LINE__);
        }
        $this->FaturaAdresSatir1 = $faturaAdresSatir1;
        return $this;
    }
    /**
     * Get FaturaAdresSatir2 value
     * @return string|null
     */
    public function getFaturaAdresSatir2()
    {
        return $this->FaturaAdresSatir2;
    }
    /**
     * Set FaturaAdresSatir2 value
     * @param string $faturaAdresSatir2
     * @return \fk_\StructType\KCari
     */
    public function setFaturaAdresSatir2($faturaAdresSatir2 = null)
    {
        // validation for constraint: string
        if (!is_null($faturaAdresSatir2) && !is_string($faturaAdresSatir2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaAdresSatir2, true), gettype($faturaAdresSatir2)), __LINE__);
        }
        $this->FaturaAdresSatir2 = $faturaAdresSatir2;
        return $this;
    }
    /**
     * Get FaturaUnvan value
     * @return string|null
     */
    public function getFaturaUnvan()
    {
        return $this->FaturaUnvan;
    }
    /**
     * Set FaturaUnvan value
     * @param string $faturaUnvan
     * @return \fk_\StructType\KCari
     */
    public function setFaturaUnvan($faturaUnvan = null)
    {
        // validation for constraint: string
        if (!is_null($faturaUnvan) && !is_string($faturaUnvan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaUnvan, true), gettype($faturaUnvan)), __LINE__);
        }
        $this->FaturaUnvan = $faturaUnvan;
        return $this;
    }
    /**
     * Get IsTel value
     * @return string|null
     */
    public function getIsTel()
    {
        return $this->IsTel;
    }
    /**
     * Set IsTel value
     * @param string $isTel
     * @return \fk_\StructType\KCari
     */
    public function setIsTel($isTel = null)
    {
        // validation for constraint: string
        if (!is_null($isTel) && !is_string($isTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isTel, true), gettype($isTel)), __LINE__);
        }
        $this->IsTel = $isTel;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \fk_\StructType\KCari
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get KrediKartiBanka value
     * @return string|null
     */
    public function getKrediKartiBanka()
    {
        return $this->KrediKartiBanka;
    }
    /**
     * Set KrediKartiBanka value
     * @param string $krediKartiBanka
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiBanka($krediKartiBanka = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiBanka) && !is_string($krediKartiBanka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiBanka, true), gettype($krediKartiBanka)), __LINE__);
        }
        $this->KrediKartiBanka = $krediKartiBanka;
        return $this;
    }
    /**
     * Get KrediKartiCVV value
     * @return string|null
     */
    public function getKrediKartiCVV()
    {
        return $this->KrediKartiCVV;
    }
    /**
     * Set KrediKartiCVV value
     * @param string $krediKartiCVV
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiCVV($krediKartiCVV = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiCVV) && !is_string($krediKartiCVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiCVV, true), gettype($krediKartiCVV)), __LINE__);
        }
        $this->KrediKartiCVV = $krediKartiCVV;
        return $this;
    }
    /**
     * Get KrediKartiNo value
     * @return string|null
     */
    public function getKrediKartiNo()
    {
        return $this->KrediKartiNo;
    }
    /**
     * Set KrediKartiNo value
     * @param string $krediKartiNo
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiNo($krediKartiNo = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiNo) && !is_string($krediKartiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiNo, true), gettype($krediKartiNo)), __LINE__);
        }
        $this->KrediKartiNo = $krediKartiNo;
        return $this;
    }
    /**
     * Get KrediKartiSahibi value
     * @return string|null
     */
    public function getKrediKartiSahibi()
    {
        return $this->KrediKartiSahibi;
    }
    /**
     * Set KrediKartiSahibi value
     * @param string $krediKartiSahibi
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiSahibi($krediKartiSahibi = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiSahibi) && !is_string($krediKartiSahibi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiSahibi, true), gettype($krediKartiSahibi)), __LINE__);
        }
        $this->KrediKartiSahibi = $krediKartiSahibi;
        return $this;
    }
    /**
     * Get KrediKartiSKTar value
     * @return string|null
     */
    public function getKrediKartiSKTar()
    {
        return $this->KrediKartiSKTar;
    }
    /**
     * Set KrediKartiSKTar value
     * @param string $krediKartiSKTar
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiSKTar($krediKartiSKTar = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiSKTar) && !is_string($krediKartiSKTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiSKTar, true), gettype($krediKartiSKTar)), __LINE__);
        }
        $this->KrediKartiSKTar = $krediKartiSKTar;
        return $this;
    }
    /**
     * Get KrediKartiTip value
     * @return string|null
     */
    public function getKrediKartiTip()
    {
        return $this->KrediKartiTip;
    }
    /**
     * Set KrediKartiTip value
     * @param string $krediKartiTip
     * @return \fk_\StructType\KCari
     */
    public function setKrediKartiTip($krediKartiTip = null)
    {
        // validation for constraint: string
        if (!is_null($krediKartiTip) && !is_string($krediKartiTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krediKartiTip, true), gettype($krediKartiTip)), __LINE__);
        }
        $this->KrediKartiTip = $krediKartiTip;
        return $this;
    }
    /**
     * Get Sube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \fk_\StructType\KSubePointer $sube
     * @return \fk_\StructType\KCari
     */
    public function setSube(\fk_\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get Unvan value
     * @return string|null
     */
    public function getUnvan()
    {
        return $this->Unvan;
    }
    /**
     * Set Unvan value
     * @param string $unvan
     * @return \fk_\StructType\KCari
     */
    public function setUnvan($unvan = null)
    {
        // validation for constraint: string
        if (!is_null($unvan) && !is_string($unvan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unvan, true), gettype($unvan)), __LINE__);
        }
        $this->Unvan = $unvan;
        return $this;
    }
    /**
     * Get UstCari value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getUstCari()
    {
        return $this->UstCari;
    }
    /**
     * Set UstCari value
     * @param \fk_\StructType\KCariPointer $ustCari
     * @return \fk_\StructType\KCari
     */
    public function setUstCari(\fk_\StructType\KCariPointer $ustCari = null)
    {
        $this->UstCari = $ustCari;
        return $this;
    }
    /**
     * Get VergiDaire value
     * @return string|null
     */
    public function getVergiDaire()
    {
        return $this->VergiDaire;
    }
    /**
     * Set VergiDaire value
     * @param string $vergiDaire
     * @return \fk_\StructType\KCari
     */
    public function setVergiDaire($vergiDaire = null)
    {
        // validation for constraint: string
        if (!is_null($vergiDaire) && !is_string($vergiDaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vergiDaire, true), gettype($vergiDaire)), __LINE__);
        }
        $this->VergiDaire = $vergiDaire;
        return $this;
    }
    /**
     * Get VergiNo value
     * @return string|null
     */
    public function getVergiNo()
    {
        return $this->VergiNo;
    }
    /**
     * Set VergiNo value
     * @param string $vergiNo
     * @return \fk_\StructType\KCari
     */
    public function setVergiNo($vergiNo = null)
    {
        // validation for constraint: string
        if (!is_null($vergiNo) && !is_string($vergiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vergiNo, true), gettype($vergiNo)), __LINE__);
        }
        $this->VergiNo = $vergiNo;
        return $this;
    }
    /**
     * Get YetkiliKisi value
     * @return string|null
     */
    public function getYetkiliKisi()
    {
        return $this->YetkiliKisi;
    }
    /**
     * Set YetkiliKisi value
     * @param string $yetkiliKisi
     * @return \fk_\StructType\KCari
     */
    public function setYetkiliKisi($yetkiliKisi = null)
    {
        // validation for constraint: string
        if (!is_null($yetkiliKisi) && !is_string($yetkiliKisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yetkiliKisi, true), gettype($yetkiliKisi)), __LINE__);
        }
        $this->YetkiliKisi = $yetkiliKisi;
        return $this;
    }
    /**
     * Get WebUserName value
     * @return string|null
     */
    public function getWebUserName()
    {
        return $this->WebUserName;
    }
    /**
     * Set WebUserName value
     * @param string $webUserName
     * @return \fk_\StructType\KCari
     */
    public function setWebUserName($webUserName = null)
    {
        // validation for constraint: string
        if (!is_null($webUserName) && !is_string($webUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webUserName, true), gettype($webUserName)), __LINE__);
        }
        $this->WebUserName = $webUserName;
        return $this;
    }
    /**
     * Get WebPassword value
     * @return string|null
     */
    public function getWebPassword()
    {
        return $this->WebPassword;
    }
    /**
     * Set WebPassword value
     * @param string $webPassword
     * @return \fk_\StructType\KCari
     */
    public function setWebPassword($webPassword = null)
    {
        // validation for constraint: string
        if (!is_null($webPassword) && !is_string($webPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webPassword, true), gettype($webPassword)), __LINE__);
        }
        $this->WebPassword = $webPassword;
        return $this;
    }
    /**
     * Get DagitimSubesi value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getDagitimSubesi()
    {
        return $this->DagitimSubesi;
    }
    /**
     * Set DagitimSubesi value
     * @param \fk_\StructType\KSubePointer $dagitimSubesi
     * @return \fk_\StructType\KCari
     */
    public function setDagitimSubesi(\fk_\StructType\KSubePointer $dagitimSubesi = null)
    {
        $this->DagitimSubesi = $dagitimSubesi;
        return $this;
    }
    /**
     * Get Sektor value
     * @return \fk_\StructType\KLookupTablePointer|null
     */
    public function getSektor()
    {
        return $this->Sektor;
    }
    /**
     * Set Sektor value
     * @param \fk_\StructType\KLookupTablePointer $sektor
     * @return \fk_\StructType\KCari
     */
    public function setSektor(\fk_\StructType\KLookupTablePointer $sektor = null)
    {
        $this->Sektor = $sektor;
        return $this;
    }
    /**
     * Get GGPassword value
     * @return string|null
     */
    public function getGGPassword()
    {
        return $this->GGPassword;
    }
    /**
     * Set GGPassword value
     * @param string $gGPassword
     * @return \fk_\StructType\KCari
     */
    public function setGGPassword($gGPassword = null)
    {
        // validation for constraint: string
        if (!is_null($gGPassword) && !is_string($gGPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gGPassword, true), gettype($gGPassword)), __LINE__);
        }
        $this->GGPassword = $gGPassword;
        return $this;
    }
    /**
     * Get VergiDairesi value
     * @return \fk_\StructType\KVergiDairesiPointer|null
     */
    public function getVergiDairesi()
    {
        return $this->VergiDairesi;
    }
    /**
     * Set VergiDairesi value
     * @param \fk_\StructType\KVergiDairesiPointer $vergiDairesi
     * @return \fk_\StructType\KCari
     */
    public function setVergiDairesi(\fk_\StructType\KVergiDairesiPointer $vergiDairesi = null)
    {
        $this->VergiDairesi = $vergiDairesi;
        return $this;
    }
    /**
     * Get SegmentKodu value
     * @return \fk_\StructType\KLookupTablePointer|null
     */
    public function getSegmentKodu()
    {
        return $this->SegmentKodu;
    }
    /**
     * Set SegmentKodu value
     * @param \fk_\StructType\KLookupTablePointer $segmentKodu
     * @return \fk_\StructType\KCari
     */
    public function setSegmentKodu(\fk_\StructType\KLookupTablePointer $segmentKodu = null)
    {
        $this->SegmentKodu = $segmentKodu;
        return $this;
    }
    /**
     * Get Zimmetli value
     * @return \fk_\StructType\KPersonelPointer|null
     */
    public function getZimmetli()
    {
        return $this->Zimmetli;
    }
    /**
     * Set Zimmetli value
     * @param \fk_\StructType\KPersonelPointer $zimmetli
     * @return \fk_\StructType\KCari
     */
    public function setZimmetli(\fk_\StructType\KPersonelPointer $zimmetli = null)
    {
        $this->Zimmetli = $zimmetli;
        return $this;
    }
    /**
     * Get EvrakKaydetmekIcinYetkiliSubeler value
     * @return string|null
     */
    public function getEvrakKaydetmekIcinYetkiliSubeler()
    {
        return $this->EvrakKaydetmekIcinYetkiliSubeler;
    }
    /**
     * Set EvrakKaydetmekIcinYetkiliSubeler value
     * @param string $evrakKaydetmekIcinYetkiliSubeler
     * @return \fk_\StructType\KCari
     */
    public function setEvrakKaydetmekIcinYetkiliSubeler($evrakKaydetmekIcinYetkiliSubeler = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKaydetmekIcinYetkiliSubeler) && !is_string($evrakKaydetmekIcinYetkiliSubeler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKaydetmekIcinYetkiliSubeler, true), gettype($evrakKaydetmekIcinYetkiliSubeler)), __LINE__);
        }
        $this->EvrakKaydetmekIcinYetkiliSubeler = $evrakKaydetmekIcinYetkiliSubeler;
        return $this;
    }
    /**
     * Get WebServisSifre value
     * @return string|null
     */
    public function getWebServisSifre()
    {
        return $this->WebServisSifre;
    }
    /**
     * Set WebServisSifre value
     * @param string $webServisSifre
     * @return \fk_\StructType\KCari
     */
    public function setWebServisSifre($webServisSifre = null)
    {
        // validation for constraint: string
        if (!is_null($webServisSifre) && !is_string($webServisSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webServisSifre, true), gettype($webServisSifre)), __LINE__);
        }
        $this->WebServisSifre = $webServisSifre;
        return $this;
    }
    /**
     * Get TeslimEdenYetkili value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getTeslimEdenYetkili()
    {
        return $this->TeslimEdenYetkili;
    }
    /**
     * Set TeslimEdenYetkili value
     * @param \fk_\StructType\KCariPointer $teslimEdenYetkili
     * @return \fk_\StructType\KCari
     */
    public function setTeslimEdenYetkili(\fk_\StructType\KCariPointer $teslimEdenYetkili = null)
    {
        $this->TeslimEdenYetkili = $teslimEdenYetkili;
        return $this;
    }
    /**
     * Get TeslimAlanYetkili value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getTeslimAlanYetkili()
    {
        return $this->TeslimAlanYetkili;
    }
    /**
     * Set TeslimAlanYetkili value
     * @param \fk_\StructType\KCariPointer $teslimAlanYetkili
     * @return \fk_\StructType\KCari
     */
    public function setTeslimAlanYetkili(\fk_\StructType\KCariPointer $teslimAlanYetkili = null)
    {
        $this->TeslimAlanYetkili = $teslimAlanYetkili;
        return $this;
    }
    /**
     * Get Uyruk value
     * @return string|null
     */
    public function getUyruk()
    {
        return $this->Uyruk;
    }
    /**
     * Set Uyruk value
     * @param string $uyruk
     * @return \fk_\StructType\KCari
     */
    public function setUyruk($uyruk = null)
    {
        // validation for constraint: string
        if (!is_null($uyruk) && !is_string($uyruk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyruk, true), gettype($uyruk)), __LINE__);
        }
        $this->Uyruk = $uyruk;
        return $this;
    }
    /**
     * Get Rapor_UstCari value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getRapor_UstCari()
    {
        return $this->Rapor_UstCari;
    }
    /**
     * Set Rapor_UstCari value
     * @param \fk_\StructType\KCariPointer $rapor_UstCari
     * @return \fk_\StructType\KCari
     */
    public function setRapor_UstCari(\fk_\StructType\KCariPointer $rapor_UstCari = null)
    {
        $this->Rapor_UstCari = $rapor_UstCari;
        return $this;
    }
    /**
     * Get CariMailleri value
     * @return \fk_\ArrayType\ArrayOfKCariMail|null
     */
    public function getCariMailleri()
    {
        return $this->CariMailleri;
    }
    /**
     * Set CariMailleri value
     * @param \fk_\ArrayType\ArrayOfKCariMail $cariMailleri
     * @return \fk_\StructType\KCari
     */
    public function setCariMailleri(\fk_\ArrayType\ArrayOfKCariMail $cariMailleri = null)
    {
        $this->CariMailleri = $cariMailleri;
        return $this;
    }
    /**
     * Get AltSektor value
     * @return \fk_\ArrayType\ArrayOfLong|null
     */
    public function getAltSektor()
    {
        return $this->AltSektor;
    }
    /**
     * Set AltSektor value
     * @param \fk_\ArrayType\ArrayOfLong $altSektor
     * @return \fk_\StructType\KCari
     */
    public function setAltSektor(\fk_\ArrayType\ArrayOfLong $altSektor = null)
    {
        $this->AltSektor = $altSektor;
        return $this;
    }
    /**
     * Get MusteriNo value
     * @return string|null
     */
    public function getMusteriNo()
    {
        return $this->MusteriNo;
    }
    /**
     * Set MusteriNo value
     * @param string $musteriNo
     * @return \fk_\StructType\KCari
     */
    public function setMusteriNo($musteriNo = null)
    {
        // validation for constraint: string
        if (!is_null($musteriNo) && !is_string($musteriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriNo, true), gettype($musteriNo)), __LINE__);
        }
        $this->MusteriNo = $musteriNo;
        return $this;
    }
    /**
     * Get BayiNo value
     * @return string|null
     */
    public function getBayiNo()
    {
        return $this->BayiNo;
    }
    /**
     * Set BayiNo value
     * @param string $bayiNo
     * @return \fk_\StructType\KCari
     */
    public function setBayiNo($bayiNo = null)
    {
        // validation for constraint: string
        if (!is_null($bayiNo) && !is_string($bayiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bayiNo, true), gettype($bayiNo)), __LINE__);
        }
        $this->BayiNo = $bayiNo;
        return $this;
    }
    /**
     * Get PostaKodu value
     * @return string|null
     */
    public function getPostaKodu()
    {
        return $this->PostaKodu;
    }
    /**
     * Set PostaKodu value
     * @param string $postaKodu
     * @return \fk_\StructType\KCari
     */
    public function setPostaKodu($postaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($postaKodu) && !is_string($postaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postaKodu, true), gettype($postaKodu)), __LINE__);
        }
        $this->PostaKodu = $postaKodu;
        return $this;
    }
    /**
     * Get Resim value
     * @return string|null
     */
    public function getResim()
    {
        return $this->Resim;
    }
    /**
     * Set Resim value
     * @param string $resim
     * @return \fk_\StructType\KCari
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        $this->Resim = $resim;
        return $this;
    }
    /**
     * Get EFaturaCariHesabi value
     * @return \fk_\StructType\EFaturaCariHesabi|null
     */
    public function getEFaturaCariHesabi()
    {
        return $this->EFaturaCariHesabi;
    }
    /**
     * Set EFaturaCariHesabi value
     * @param \fk_\StructType\EFaturaCariHesabi $eFaturaCariHesabi
     * @return \fk_\StructType\KCari
     */
    public function setEFaturaCariHesabi(\fk_\StructType\EFaturaCariHesabi $eFaturaCariHesabi = null)
    {
        $this->EFaturaCariHesabi = $eFaturaCariHesabi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KCari
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
