<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankaHesabi StructType
 * @subpackage Structs
 */
class BankaHesabi extends Hesap
{
    /**
     * The HesapTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HesapTuru;
    /**
     * The CalismaKomisyonu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CalismaKomisyonu;
    /**
     * The HediyePuanKomisyonu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $HediyePuanKomisyonu;
    /**
     * The PosTahsilatVade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PosTahsilatVade;
    /**
     * The OnayTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OnayTarihi;
    /**
     * The SadecePozitif
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SadecePozitif;
    /**
     * The HesapDovizi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizTuruPointer
     */
    public $HesapDovizi;
    /**
     * The HesapNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HesapNo;
    /**
     * The Subesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\BankaSubesiPointer
     */
    public $Subesi;
    /**
     * The Bakiyeler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfBankaHesabiBakiye
     */
    public $Bakiyeler;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The EntegrasyonKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntegrasyonKodu;
    /**
     * The EntegrasyonSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntegrasyonSifre;
    /**
     * The WebServisAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebServisAdresi;
    /**
     * The FtpServisAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FtpServisAdresi;
    /**
     * The MuhasebeHesapSablonu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer
     */
    public $MuhasebeHesapSablonu;
    /**
     * Constructor method for BankaHesabi
     * @uses BankaHesabi::setHesapTuru()
     * @uses BankaHesabi::setCalismaKomisyonu()
     * @uses BankaHesabi::setHediyePuanKomisyonu()
     * @uses BankaHesabi::setPosTahsilatVade()
     * @uses BankaHesabi::setOnayTarihi()
     * @uses BankaHesabi::setSadecePozitif()
     * @uses BankaHesabi::setHesapDovizi()
     * @uses BankaHesabi::setHesapNo()
     * @uses BankaHesabi::setSubesi()
     * @uses BankaHesabi::setBakiyeler()
     * @uses BankaHesabi::setIBAN()
     * @uses BankaHesabi::setEntegrasyonKodu()
     * @uses BankaHesabi::setEntegrasyonSifre()
     * @uses BankaHesabi::setWebServisAdresi()
     * @uses BankaHesabi::setFtpServisAdresi()
     * @uses BankaHesabi::setMuhasebeHesapSablonu()
     * @param string $hesapTuru
     * @param float $calismaKomisyonu
     * @param float $hediyePuanKomisyonu
     * @param int $posTahsilatVade
     * @param string $onayTarihi
     * @param bool $sadecePozitif
     * @param \fk_\StructType\DovizTuruPointer $hesapDovizi
     * @param string $hesapNo
     * @param \fk_\StructType\BankaSubesiPointer $subesi
     * @param \fk_\ArrayType\ArrayOfBankaHesabiBakiye $bakiyeler
     * @param string $iBAN
     * @param string $entegrasyonKodu
     * @param string $entegrasyonSifre
     * @param string $webServisAdresi
     * @param string $ftpServisAdresi
     * @param \fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer $muhasebeHesapSablonu
     */
    public function __construct($hesapTuru = null, $calismaKomisyonu = null, $hediyePuanKomisyonu = null, $posTahsilatVade = null, $onayTarihi = null, $sadecePozitif = null, \fk_\StructType\DovizTuruPointer $hesapDovizi = null, $hesapNo = null, \fk_\StructType\BankaSubesiPointer $subesi = null, \fk_\ArrayType\ArrayOfBankaHesabiBakiye $bakiyeler = null, $iBAN = null, $entegrasyonKodu = null, $entegrasyonSifre = null, $webServisAdresi = null, $ftpServisAdresi = null, \fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer $muhasebeHesapSablonu = null)
    {
        $this
            ->setHesapTuru($hesapTuru)
            ->setCalismaKomisyonu($calismaKomisyonu)
            ->setHediyePuanKomisyonu($hediyePuanKomisyonu)
            ->setPosTahsilatVade($posTahsilatVade)
            ->setOnayTarihi($onayTarihi)
            ->setSadecePozitif($sadecePozitif)
            ->setHesapDovizi($hesapDovizi)
            ->setHesapNo($hesapNo)
            ->setSubesi($subesi)
            ->setBakiyeler($bakiyeler)
            ->setIBAN($iBAN)
            ->setEntegrasyonKodu($entegrasyonKodu)
            ->setEntegrasyonSifre($entegrasyonSifre)
            ->setWebServisAdresi($webServisAdresi)
            ->setFtpServisAdresi($ftpServisAdresi)
            ->setMuhasebeHesapSablonu($muhasebeHesapSablonu);
    }
    /**
     * Get HesapTuru value
     * @return string
     */
    public function getHesapTuru()
    {
        return $this->HesapTuru;
    }
    /**
     * Set HesapTuru value
     * @uses \fk_\EnumType\BankaHesabiTuru::valueIsValid()
     * @uses \fk_\EnumType\BankaHesabiTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hesapTuru
     * @return \fk_\StructType\BankaHesabi
     */
    public function setHesapTuru($hesapTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\BankaHesabiTuru::valueIsValid($hesapTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\BankaHesabiTuru', is_array($hesapTuru) ? implode(', ', $hesapTuru) : var_export($hesapTuru, true), implode(', ', \fk_\EnumType\BankaHesabiTuru::getValidValues())), __LINE__);
        }
        $this->HesapTuru = $hesapTuru;
        return $this;
    }
    /**
     * Get CalismaKomisyonu value
     * @return float
     */
    public function getCalismaKomisyonu()
    {
        return $this->CalismaKomisyonu;
    }
    /**
     * Set CalismaKomisyonu value
     * @param float $calismaKomisyonu
     * @return \fk_\StructType\BankaHesabi
     */
    public function setCalismaKomisyonu($calismaKomisyonu = null)
    {
        // validation for constraint: float
        if (!is_null($calismaKomisyonu) && !(is_float($calismaKomisyonu) || is_numeric($calismaKomisyonu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calismaKomisyonu, true), gettype($calismaKomisyonu)), __LINE__);
        }
        $this->CalismaKomisyonu = $calismaKomisyonu;
        return $this;
    }
    /**
     * Get HediyePuanKomisyonu value
     * @return float
     */
    public function getHediyePuanKomisyonu()
    {
        return $this->HediyePuanKomisyonu;
    }
    /**
     * Set HediyePuanKomisyonu value
     * @param float $hediyePuanKomisyonu
     * @return \fk_\StructType\BankaHesabi
     */
    public function setHediyePuanKomisyonu($hediyePuanKomisyonu = null)
    {
        // validation for constraint: float
        if (!is_null($hediyePuanKomisyonu) && !(is_float($hediyePuanKomisyonu) || is_numeric($hediyePuanKomisyonu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hediyePuanKomisyonu, true), gettype($hediyePuanKomisyonu)), __LINE__);
        }
        $this->HediyePuanKomisyonu = $hediyePuanKomisyonu;
        return $this;
    }
    /**
     * Get PosTahsilatVade value
     * @return int
     */
    public function getPosTahsilatVade()
    {
        return $this->PosTahsilatVade;
    }
    /**
     * Set PosTahsilatVade value
     * @param int $posTahsilatVade
     * @return \fk_\StructType\BankaHesabi
     */
    public function setPosTahsilatVade($posTahsilatVade = null)
    {
        // validation for constraint: int
        if (!is_null($posTahsilatVade) && !(is_int($posTahsilatVade) || ctype_digit($posTahsilatVade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($posTahsilatVade, true), gettype($posTahsilatVade)), __LINE__);
        }
        $this->PosTahsilatVade = $posTahsilatVade;
        return $this;
    }
    /**
     * Get OnayTarihi value
     * @return string
     */
    public function getOnayTarihi()
    {
        return $this->OnayTarihi;
    }
    /**
     * Set OnayTarihi value
     * @param string $onayTarihi
     * @return \fk_\StructType\BankaHesabi
     */
    public function setOnayTarihi($onayTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($onayTarihi) && !is_string($onayTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onayTarihi, true), gettype($onayTarihi)), __LINE__);
        }
        $this->OnayTarihi = $onayTarihi;
        return $this;
    }
    /**
     * Get SadecePozitif value
     * @return bool
     */
    public function getSadecePozitif()
    {
        return $this->SadecePozitif;
    }
    /**
     * Set SadecePozitif value
     * @param bool $sadecePozitif
     * @return \fk_\StructType\BankaHesabi
     */
    public function setSadecePozitif($sadecePozitif = null)
    {
        // validation for constraint: boolean
        if (!is_null($sadecePozitif) && !is_bool($sadecePozitif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sadecePozitif, true), gettype($sadecePozitif)), __LINE__);
        }
        $this->SadecePozitif = $sadecePozitif;
        return $this;
    }
    /**
     * Get HesapDovizi value
     * @return \fk_\StructType\DovizTuruPointer|null
     */
    public function getHesapDovizi()
    {
        return $this->HesapDovizi;
    }
    /**
     * Set HesapDovizi value
     * @param \fk_\StructType\DovizTuruPointer $hesapDovizi
     * @return \fk_\StructType\BankaHesabi
     */
    public function setHesapDovizi(\fk_\StructType\DovizTuruPointer $hesapDovizi = null)
    {
        $this->HesapDovizi = $hesapDovizi;
        return $this;
    }
    /**
     * Get HesapNo value
     * @return string|null
     */
    public function getHesapNo()
    {
        return $this->HesapNo;
    }
    /**
     * Set HesapNo value
     * @param string $hesapNo
     * @return \fk_\StructType\BankaHesabi
     */
    public function setHesapNo($hesapNo = null)
    {
        // validation for constraint: string
        if (!is_null($hesapNo) && !is_string($hesapNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hesapNo, true), gettype($hesapNo)), __LINE__);
        }
        $this->HesapNo = $hesapNo;
        return $this;
    }
    /**
     * Get Subesi value
     * @return \fk_\StructType\BankaSubesiPointer|null
     */
    public function getSubesi()
    {
        return $this->Subesi;
    }
    /**
     * Set Subesi value
     * @param \fk_\StructType\BankaSubesiPointer $subesi
     * @return \fk_\StructType\BankaHesabi
     */
    public function setSubesi(\fk_\StructType\BankaSubesiPointer $subesi = null)
    {
        $this->Subesi = $subesi;
        return $this;
    }
    /**
     * Get Bakiyeler value
     * @return \fk_\ArrayType\ArrayOfBankaHesabiBakiye|null
     */
    public function getBakiyeler()
    {
        return $this->Bakiyeler;
    }
    /**
     * Set Bakiyeler value
     * @param \fk_\ArrayType\ArrayOfBankaHesabiBakiye $bakiyeler
     * @return \fk_\StructType\BankaHesabi
     */
    public function setBakiyeler(\fk_\ArrayType\ArrayOfBankaHesabiBakiye $bakiyeler = null)
    {
        $this->Bakiyeler = $bakiyeler;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \fk_\StructType\BankaHesabi
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get EntegrasyonKodu value
     * @return string|null
     */
    public function getEntegrasyonKodu()
    {
        return $this->EntegrasyonKodu;
    }
    /**
     * Set EntegrasyonKodu value
     * @param string $entegrasyonKodu
     * @return \fk_\StructType\BankaHesabi
     */
    public function setEntegrasyonKodu($entegrasyonKodu = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonKodu) && !is_string($entegrasyonKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entegrasyonKodu, true), gettype($entegrasyonKodu)), __LINE__);
        }
        $this->EntegrasyonKodu = $entegrasyonKodu;
        return $this;
    }
    /**
     * Get EntegrasyonSifre value
     * @return string|null
     */
    public function getEntegrasyonSifre()
    {
        return $this->EntegrasyonSifre;
    }
    /**
     * Set EntegrasyonSifre value
     * @param string $entegrasyonSifre
     * @return \fk_\StructType\BankaHesabi
     */
    public function setEntegrasyonSifre($entegrasyonSifre = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonSifre) && !is_string($entegrasyonSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entegrasyonSifre, true), gettype($entegrasyonSifre)), __LINE__);
        }
        $this->EntegrasyonSifre = $entegrasyonSifre;
        return $this;
    }
    /**
     * Get WebServisAdresi value
     * @return string|null
     */
    public function getWebServisAdresi()
    {
        return $this->WebServisAdresi;
    }
    /**
     * Set WebServisAdresi value
     * @param string $webServisAdresi
     * @return \fk_\StructType\BankaHesabi
     */
    public function setWebServisAdresi($webServisAdresi = null)
    {
        // validation for constraint: string
        if (!is_null($webServisAdresi) && !is_string($webServisAdresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webServisAdresi, true), gettype($webServisAdresi)), __LINE__);
        }
        $this->WebServisAdresi = $webServisAdresi;
        return $this;
    }
    /**
     * Get FtpServisAdresi value
     * @return string|null
     */
    public function getFtpServisAdresi()
    {
        return $this->FtpServisAdresi;
    }
    /**
     * Set FtpServisAdresi value
     * @param string $ftpServisAdresi
     * @return \fk_\StructType\BankaHesabi
     */
    public function setFtpServisAdresi($ftpServisAdresi = null)
    {
        // validation for constraint: string
        if (!is_null($ftpServisAdresi) && !is_string($ftpServisAdresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ftpServisAdresi, true), gettype($ftpServisAdresi)), __LINE__);
        }
        $this->FtpServisAdresi = $ftpServisAdresi;
        return $this;
    }
    /**
     * Get MuhasebeHesapSablonu value
     * @return \fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer|null
     */
    public function getMuhasebeHesapSablonu()
    {
        return $this->MuhasebeHesapSablonu;
    }
    /**
     * Set MuhasebeHesapSablonu value
     * @param \fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer $muhasebeHesapSablonu
     * @return \fk_\StructType\BankaHesabi
     */
    public function setMuhasebeHesapSablonu(\fk_\StructType\BankaHesabiMuhasebeHesapSablonuPointer $muhasebeHesapSablonu = null)
    {
        $this->MuhasebeHesapSablonu = $muhasebeHesapSablonu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\BankaHesabi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
