<?php

namespace fk_\EnumType;

/**
 * This class stands for EvrakGonderimSekli EnumType
 * @subpackage Enumerations
 */
class EvrakGonderimSekli
{
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Constant for value 'Havale'
     * @return string 'Havale'
     */
    const VALUE_HAVALE = 'Havale';
    /**
     * Constant for value 'EFT'
     * @return string 'EFT'
     */
    const VALUE_EFT = 'EFT';
    /**
     * Constant for value 'Belirsiz'
     * @return string 'Belirsiz'
     */
    const VALUE_BELIRSIZ = 'Belirsiz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HEPSI
     * @uses self::VALUE_HAVALE
     * @uses self::VALUE_EFT
     * @uses self::VALUE_BELIRSIZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HEPSI,
            self::VALUE_HAVALE,
            self::VALUE_EFT,
            self::VALUE_BELIRSIZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
