<?php

namespace fk_\EnumType;

/**
 * This class stands for BankaHesabiTuru EnumType
 * @subpackage Enumerations
 */
class BankaHesabiTuru
{
    /**
     * Constant for value 'TicariHesap'
     * @return string 'TicariHesap'
     */
    const VALUE_TICARI_HESAP = 'TicariHesap';
    /**
     * Constant for value 'KrediHesabi'
     * @return string 'KrediHesabi'
     */
    const VALUE_KREDI_HESABI = 'KrediHesabi';
    /**
     * Constant for value 'DovizliTicariHesap'
     * @return string 'DovizliTicariHesap'
     */
    const VALUE_DOVIZLI_TICARI_HESAP = 'DovizliTicariHesap';
    /**
     * Constant for value 'DovizliKrediHesabi'
     * @return string 'DovizliKrediHesabi'
     */
    const VALUE_DOVIZLI_KREDI_HESABI = 'DovizliKrediHesabi';
    /**
     * Constant for value 'KrediKartiHesabi'
     * @return string 'KrediKartiHesabi'
     */
    const VALUE_KREDI_KARTI_HESABI = 'KrediKartiHesabi';
    /**
     * Constant for value 'DovizliKrediKartiHesabi'
     * @return string 'DovizliKrediKartiHesabi'
     */
    const VALUE_DOVIZLI_KREDI_KARTI_HESABI = 'DovizliKrediKartiHesabi';
    /**
     * Constant for value 'PosHesabi'
     * @return string 'PosHesabi'
     */
    const VALUE_POS_HESABI = 'PosHesabi';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TICARI_HESAP
     * @uses self::VALUE_KREDI_HESABI
     * @uses self::VALUE_DOVIZLI_TICARI_HESAP
     * @uses self::VALUE_DOVIZLI_KREDI_HESABI
     * @uses self::VALUE_KREDI_KARTI_HESABI
     * @uses self::VALUE_DOVIZLI_KREDI_KARTI_HESABI
     * @uses self::VALUE_POS_HESABI
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TICARI_HESAP,
            self::VALUE_KREDI_HESABI,
            self::VALUE_DOVIZLI_TICARI_HESAP,
            self::VALUE_DOVIZLI_KREDI_HESABI,
            self::VALUE_KREDI_KARTI_HESABI,
            self::VALUE_DOVIZLI_KREDI_KARTI_HESABI,
            self::VALUE_POS_HESABI,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
