<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracBelgeTip EnumType
 * @subpackage Enumerations
 */
class KAracBelgeTip
{
    /**
     * Constant for value 'K1YetkiBelgesi'
     * @return string 'K1YetkiBelgesi'
     */
    const VALUE_K_1_YETKI_BELGESI = 'K1YetkiBelgesi';
    /**
     * Constant for value 'M2YetkiBelgesi'
     * @return string 'M2YetkiBelgesi'
     */
    const VALUE_M_2_YETKI_BELGESI = 'M2YetkiBelgesi';
    /**
     * Constant for value 'L1YetkiBelgesi'
     * @return string 'L1YetkiBelgesi'
     */
    const VALUE_L_1_YETKI_BELGESI = 'L1YetkiBelgesi';
    /**
     * Constant for value 'RYetkiBelgesi'
     * @return string 'RYetkiBelgesi'
     */
    const VALUE_RYETKI_BELGESI = 'RYetkiBelgesi';
    /**
     * Constant for value 'K1YildizliYetkiBelgesi'
     * @return string 'K1YildizliYetkiBelgesi'
     */
    const VALUE_K_1_YILDIZLI_YETKI_BELGESI = 'K1YildizliYetkiBelgesi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_K_1_YETKI_BELGESI
     * @uses self::VALUE_M_2_YETKI_BELGESI
     * @uses self::VALUE_L_1_YETKI_BELGESI
     * @uses self::VALUE_RYETKI_BELGESI
     * @uses self::VALUE_K_1_YILDIZLI_YETKI_BELGESI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_K_1_YETKI_BELGESI,
            self::VALUE_M_2_YETKI_BELGESI,
            self::VALUE_L_1_YETKI_BELGESI,
            self::VALUE_RYETKI_BELGESI,
            self::VALUE_K_1_YILDIZLI_YETKI_BELGESI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
