<?php

namespace fk_\EnumType;

/**
 * This class stands for EFaturaSenaryosu EnumType
 * @subpackage Enumerations
 */
class EFaturaSenaryosu
{
    /**
     * Constant for value 'KagitFatura'
     * @return string 'KagitFatura'
     */
    const VALUE_KAGIT_FATURA = 'KagitFatura';
    /**
     * Constant for value 'TemelEFatura'
     * @return string 'TemelEFatura'
     */
    const VALUE_TEMEL_EFATURA = 'TemelEFatura';
    /**
     * Constant for value 'TicariEFatura'
     * @return string 'TicariEFatura'
     */
    const VALUE_TICARI_EFATURA = 'TicariEFatura';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAGIT_FATURA
     * @uses self::VALUE_TEMEL_EFATURA
     * @uses self::VALUE_TICARI_EFATURA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAGIT_FATURA,
            self::VALUE_TEMEL_EFATURA,
            self::VALUE_TICARI_EFATURA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
