<?php

namespace fk_\EnumType;

/**
 * This class stands for KEvrakSubeTipi EnumType
 * @subpackage Enumerations
 */
class KEvrakSubeTipi
{
    /**
     * Constant for value 'Sadece_Gonderen_SubeVar'
     * @return string 'Sadece_Gonderen_SubeVar'
     */
    const VALUE_SADECE_GONDEREN_SUBE_VAR = 'Sadece_Gonderen_SubeVar';
    /**
     * Constant for value 'Gonderen_Alici_Varis_SubeVar'
     * @return string 'Gonderen_Alici_Varis_SubeVar'
     */
    const VALUE_GONDEREN_ALICI_VARIS_SUBE_VAR = 'Gonderen_Alici_Varis_SubeVar';
    /**
     * Constant for value 'Gonderen_Alici_SubeVar'
     * @return string 'Gonderen_Alici_SubeVar'
     */
    const VALUE_GONDEREN_ALICI_SUBE_VAR = 'Gonderen_Alici_SubeVar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SADECE_GONDEREN_SUBE_VAR
     * @uses self::VALUE_GONDEREN_ALICI_VARIS_SUBE_VAR
     * @uses self::VALUE_GONDEREN_ALICI_SUBE_VAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SADECE_GONDEREN_SUBE_VAR,
            self::VALUE_GONDEREN_ALICI_VARIS_SUBE_VAR,
            self::VALUE_GONDEREN_ALICI_SUBE_VAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
