<?php

namespace fk_\EnumType;

/**
 * This class stands for HizmetTipi EnumType
 * @subpackage Enumerations
 */
class HizmetTipi
{
    /**
     * Constant for value 'YurticiKargo'
     * @return string 'YurticiKargo'
     */
    const VALUE_YURTICI_KARGO = 'YurticiKargo';
    /**
     * Constant for value 'UluslararasiKargo'
     * @return string 'UluslararasiKargo'
     */
    const VALUE_ULUSLARARASI_KARGO = 'UluslararasiKargo';
    /**
     * Constant for value 'YurticiLojistik'
     * @return string 'YurticiLojistik'
     */
    const VALUE_YURTICI_LOJISTIK = 'YurticiLojistik';
    /**
     * Constant for value 'UluslararasiLojistik'
     * @return string 'UluslararasiLojistik'
     */
    const VALUE_ULUSLARARASI_LOJISTIK = 'UluslararasiLojistik';
    /**
     * Constant for value 'GazeteDagitim'
     * @return string 'GazeteDagitim'
     */
    const VALUE_GAZETE_DAGITIM = 'GazeteDagitim';
    /**
     * Constant for value 'AracKiralama'
     * @return string 'AracKiralama'
     */
    const VALUE_ARAC_KIRALAMA = 'AracKiralama';
    /**
     * Constant for value 'Tahsilat'
     * @return string 'Tahsilat'
     */
    const VALUE_TAHSILAT = 'Tahsilat';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YURTICI_KARGO
     * @uses self::VALUE_ULUSLARARASI_KARGO
     * @uses self::VALUE_YURTICI_LOJISTIK
     * @uses self::VALUE_ULUSLARARASI_LOJISTIK
     * @uses self::VALUE_GAZETE_DAGITIM
     * @uses self::VALUE_ARAC_KIRALAMA
     * @uses self::VALUE_TAHSILAT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YURTICI_KARGO,
            self::VALUE_ULUSLARARASI_KARGO,
            self::VALUE_YURTICI_LOJISTIK,
            self::VALUE_ULUSLARARASI_LOJISTIK,
            self::VALUE_GAZETE_DAGITIM,
            self::VALUE_ARAC_KIRALAMA,
            self::VALUE_TAHSILAT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
