<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileInfoWithSpecs StructType
 * @subpackage Structs
 */
class MobileInfoWithSpecs extends AbstractStructBase
{
    /**
     * The mobileInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MobileInfo
     */
    public $mobileInfo;
    /**
     * The specs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOftag_specs
     */
    public $specs;
    /**
     * Constructor method for MobileInfoWithSpecs
     * @uses MobileInfoWithSpecs::setMobileInfo()
     * @uses MobileInfoWithSpecs::setSpecs()
     * @param \StructType\MobileInfo $mobileInfo
     * @param \ArrayType\ArrayOftag_specs $specs
     */
    public function __construct(\StructType\MobileInfo $mobileInfo = null, \ArrayType\ArrayOftag_specs $specs = null)
    {
        $this
            ->setMobileInfo($mobileInfo)
            ->setSpecs($specs);
    }
    /**
     * Get mobileInfo value
     * @return \StructType\MobileInfo|null
     */
    public function getMobileInfo()
    {
        return $this->mobileInfo;
    }
    /**
     * Set mobileInfo value
     * @param \StructType\MobileInfo $mobileInfo
     * @return \StructType\MobileInfoWithSpecs
     */
    public function setMobileInfo(\StructType\MobileInfo $mobileInfo = null)
    {
        $this->mobileInfo = $mobileInfo;
        return $this;
    }
    /**
     * Get specs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOftag_specs|null
     */
    public function getSpecs()
    {
        return isset($this->specs) ? $this->specs : null;
    }
    /**
     * Set specs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOftag_specs $specs
     * @return \StructType\MobileInfoWithSpecs
     */
    public function setSpecs(\ArrayType\ArrayOftag_specs $specs = null)
    {
        if (is_null($specs) || (is_array($specs) && empty($specs))) {
            unset($this->specs);
        } else {
            $this->specs = $specs;
        }
        return $this;
    }
}
