<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlertListResponse StructType
 * @subpackage Structs
 */
class AlertListResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The alertList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAlert
     */
    public $alertList;
    /**
     * Constructor method for AlertListResponse
     * @uses AlertListResponse::setError_code()
     * @uses AlertListResponse::setStatus()
     * @uses AlertListResponse::setDescription()
     * @uses AlertListResponse::setAlertList()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfAlert $alertList
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfAlert $alertList = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setAlertList($alertList);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\AlertListResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\AlertListResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AlertListResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get alertList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAlert|null
     */
    public function getAlertList()
    {
        return isset($this->alertList) ? $this->alertList : null;
    }
    /**
     * Set alertList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAlert $alertList
     * @return \StructType\AlertListResponse
     */
    public function setAlertList(\ArrayType\ArrayOfAlert $alertList = null)
    {
        if (is_null($alertList) || (is_array($alertList) && empty($alertList))) {
            unset($this->alertList);
        } else {
            $this->alertList = $alertList;
        }
        return $this;
    }
}
