<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETI ServiceType
 * @subpackage Services
 */
class SETI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_ItAssign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItAssign $parameters
     * @return \StructType\SET_ItAssignResponse|bool
     */
    public function SET_ItAssign(\StructType\SET_ItAssign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_ItAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_ItAssign_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItAssign_v2 $parameters
     * @return \StructType\SET_ItAssign_v2Response|bool
     */
    public function SET_ItAssign_v2(\StructType\SET_ItAssign_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_ItAssign_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_ItCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ItCancel $parameters
     * @return \StructType\SET_ItCancelResponse|bool
     */
    public function SET_ItCancel(\StructType\SET_ItCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_ItCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_ItAssignResponse|\StructType\SET_ItAssign_v2Response|\StructType\SET_ItCancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
