<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETT ServiceType
 * @subpackage Services
 */
class GETT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_TrackerOdometer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerOdometer $parameters
     * @return \StructType\GET_TrackerOdometerResponse|bool
     */
    public function GET_TrackerOdometer(\StructType\GET_TrackerOdometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerOdometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TrackerEventsHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerEventsHistory $parameters
     * @return \StructType\GET_TrackerEventsHistoryResponse|bool
     */
    public function GET_TrackerEventsHistory(\StructType\GET_TrackerEventsHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerEventsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TrackerHorometer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerHorometer $parameters
     * @return \StructType\GET_TrackerHorometerResponse|bool
     */
    public function GET_TrackerHorometer(\StructType\GET_TrackerHorometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerHorometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TrackerGeofences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerGeofences $parameters
     * @return \StructType\GET_TrackerGeofencesResponse|bool
     */
    public function GET_TrackerGeofences(\StructType\GET_TrackerGeofences $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerGeofences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_TrackerEventsHistoryResponse|\StructType\GET_TrackerGeofencesResponse|\StructType\GET_TrackerHorometerResponse|\StructType\GET_TrackerOdometerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
