<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETI ServiceType
 * @subpackage Services
 */
class GETI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_ItinerariesHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItinerariesHistory $parameters
     * @return \StructType\GET_ItinerariesHistoryResponse|bool
     */
    public function GET_ItinerariesHistory(\StructType\GET_ItinerariesHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_ItinerariesHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_ItinerariesHistory_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItinerariesHistory_v2 $parameters
     * @return \StructType\GET_ItinerariesHistory_v2Response|bool
     */
    public function GET_ItinerariesHistory_v2(\StructType\GET_ItinerariesHistory_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_ItinerariesHistory_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_Itineraries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Itineraries $parameters
     * @return \StructType\GET_ItinerariesResponse|bool
     */
    public function GET_Itineraries(\StructType\GET_Itineraries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_Itineraries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_ItPointHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItPointHistory $parameters
     * @return \StructType\GET_ItPointHistoryResponse|bool
     */
    public function GET_ItPointHistory(\StructType\GET_ItPointHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_ItPointHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_ItinerariesHistoryResponse|\StructType\GET_ItinerariesHistory_v2Response|\StructType\GET_ItinerariesResponse|\StructType\GET_ItPointHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
