<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETD ServiceType
 * @subpackage Services
 */
class GETD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_Drivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Drivers $parameters
     * @return \StructType\GET_DriversResponse|bool
     */
    public function GET_Drivers(\StructType\GET_Drivers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_Drivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_Drivers_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Drivers_v2 $parameters
     * @return \StructType\GET_Drivers_v2Response|bool
     */
    public function GET_Drivers_v2(\StructType\GET_Drivers_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_Drivers_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_DriversByStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_DriversByStatus $parameters
     * @return \StructType\GET_DriversByStatusResponse|bool
     */
    public function GET_DriversByStatus(\StructType\GET_DriversByStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_DriversByStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_DriversHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_DriversHistory $parameters
     * @return \StructType\GET_DriversHistoryResponse|bool
     */
    public function GET_DriversHistory(\StructType\GET_DriversHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_DriversHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_DriversByStatusResponse|\StructType\GET_DriversHistoryResponse|\StructType\GET_DriversResponse|\StructType\GET_Drivers_v2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
