<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETA ServiceType
 * @subpackage Services
 */
class GETA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_AccountList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_AccountList $parameters
     * @return \StructType\GET_AccountListResponse|bool
     */
    public function GET_AccountList(\StructType\GET_AccountList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_AccountList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_AlertsHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_AlertsHistory $parameters
     * @return \StructType\GET_AlertsHistoryResponse|bool
     */
    public function GET_AlertsHistory(\StructType\GET_AlertsHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_AlertsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_AccountListResponse|\StructType\GET_AlertsHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
