<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfavl_spec ArrayType
 * @subpackage Arrays
 */
class ArrayOfavl_spec extends AbstractStructArrayBase
{
    /**
     * The avl_spec
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Avl_spec[]
     */
    public $avl_spec;
    /**
     * Constructor method for ArrayOfavl_spec
     * @uses ArrayOfavl_spec::setAvl_spec()
     * @param \StructType\Avl_spec[] $avl_spec
     */
    public function __construct(array $avl_spec = array())
    {
        $this
            ->setAvl_spec($avl_spec);
    }
    /**
     * Get avl_spec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Avl_spec[]|null
     */
    public function getAvl_spec()
    {
        return isset($this->avl_spec) ? $this->avl_spec : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAvl_spec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvl_spec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvl_specForArrayConstraintsFromSetAvl_spec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfavl_specAvl_specItem) {
            // validation for constraint: itemType
            if (!$arrayOfavl_specAvl_specItem instanceof \StructType\Avl_spec) {
                $invalidValues[] = is_object($arrayOfavl_specAvl_specItem) ? get_class($arrayOfavl_specAvl_specItem) : sprintf('%s(%s)', gettype($arrayOfavl_specAvl_specItem), var_export($arrayOfavl_specAvl_specItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The avl_spec property can only contain items of type \StructType\Avl_spec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set avl_spec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Avl_spec[] $avl_spec
     * @return \ArrayType\ArrayOfavl_spec
     */
    public function setAvl_spec(array $avl_spec = array())
    {
        // validation for constraint: array
        if ('' !== ($avl_specArrayErrorMessage = self::validateAvl_specForArrayConstraintsFromSetAvl_spec($avl_spec))) {
            throw new \InvalidArgumentException($avl_specArrayErrorMessage, __LINE__);
        }
        if (is_null($avl_spec) || (is_array($avl_spec) && empty($avl_spec))) {
            unset($this->avl_spec);
        } else {
            $this->avl_spec = $avl_spec;
        }
        return $this;
    }
    /**
     * Add item to avl_spec value
     * @throws \InvalidArgumentException
     * @param \StructType\Avl_spec $item
     * @return \ArrayType\ArrayOfavl_spec
     */
    public function addToAvl_spec(\StructType\Avl_spec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Avl_spec) {
            throw new \InvalidArgumentException(sprintf('The avl_spec property can only contain items of type \StructType\Avl_spec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->avl_spec[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Avl_spec|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Avl_spec|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Avl_spec|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Avl_spec|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Avl_spec|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string avl_spec
     */
    public function getAttributeName()
    {
        return 'avl_spec';
    }
}
