<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPayments_Fleet ArrayType
 * @subpackage Arrays
 */
class ArrayOfPayments_Fleet extends AbstractStructArrayBase
{
    /**
     * The Payments_Fleet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Payments_Fleet[]
     */
    public $Payments_Fleet;
    /**
     * Constructor method for ArrayOfPayments_Fleet
     * @uses ArrayOfPayments_Fleet::setPayments_Fleet()
     * @param \StructType\Payments_Fleet[] $payments_Fleet
     */
    public function __construct(array $payments_Fleet = array())
    {
        $this
            ->setPayments_Fleet($payments_Fleet);
    }
    /**
     * Get Payments_Fleet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Payments_Fleet[]|null
     */
    public function getPayments_Fleet()
    {
        return isset($this->Payments_Fleet) ? $this->Payments_Fleet : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments_Fleet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments_Fleet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayments_FleetForArrayConstraintsFromSetPayments_Fleet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPayments_FleetPayments_FleetItem) {
            // validation for constraint: itemType
            if (!$arrayOfPayments_FleetPayments_FleetItem instanceof \StructType\Payments_Fleet) {
                $invalidValues[] = is_object($arrayOfPayments_FleetPayments_FleetItem) ? get_class($arrayOfPayments_FleetPayments_FleetItem) : sprintf('%s(%s)', gettype($arrayOfPayments_FleetPayments_FleetItem), var_export($arrayOfPayments_FleetPayments_FleetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payments_Fleet property can only contain items of type \StructType\Payments_Fleet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payments_Fleet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Payments_Fleet[] $payments_Fleet
     * @return \ArrayType\ArrayOfPayments_Fleet
     */
    public function setPayments_Fleet(array $payments_Fleet = array())
    {
        // validation for constraint: array
        if ('' !== ($payments_FleetArrayErrorMessage = self::validatePayments_FleetForArrayConstraintsFromSetPayments_Fleet($payments_Fleet))) {
            throw new \InvalidArgumentException($payments_FleetArrayErrorMessage, __LINE__);
        }
        if (is_null($payments_Fleet) || (is_array($payments_Fleet) && empty($payments_Fleet))) {
            unset($this->Payments_Fleet);
        } else {
            $this->Payments_Fleet = $payments_Fleet;
        }
        return $this;
    }
    /**
     * Add item to Payments_Fleet value
     * @throws \InvalidArgumentException
     * @param \StructType\Payments_Fleet $item
     * @return \ArrayType\ArrayOfPayments_Fleet
     */
    public function addToPayments_Fleet(\StructType\Payments_Fleet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payments_Fleet) {
            throw new \InvalidArgumentException(sprintf('The Payments_Fleet property can only contain items of type \StructType\Payments_Fleet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payments_Fleet[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Payments_Fleet|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Payments_Fleet|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Payments_Fleet|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Payments_Fleet|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Payments_Fleet|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Payments_Fleet
     */
    public function getAttributeName()
    {
        return 'Payments_Fleet';
    }
}
