<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeofenceBasicInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfGeofenceBasicInformation extends AbstractStructArrayBase
{
    /**
     * The GeofenceBasicInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeofenceBasicInformation[]
     */
    public $GeofenceBasicInformation;
    /**
     * Constructor method for ArrayOfGeofenceBasicInformation
     * @uses ArrayOfGeofenceBasicInformation::setGeofenceBasicInformation()
     * @param \StructType\GeofenceBasicInformation[] $geofenceBasicInformation
     */
    public function __construct(array $geofenceBasicInformation = array())
    {
        $this
            ->setGeofenceBasicInformation($geofenceBasicInformation);
    }
    /**
     * Get GeofenceBasicInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeofenceBasicInformation[]|null
     */
    public function getGeofenceBasicInformation()
    {
        return isset($this->GeofenceBasicInformation) ? $this->GeofenceBasicInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGeofenceBasicInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeofenceBasicInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeofenceBasicInformationForArrayConstraintsFromSetGeofenceBasicInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGeofenceBasicInformationGeofenceBasicInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeofenceBasicInformationGeofenceBasicInformationItem instanceof \StructType\GeofenceBasicInformation) {
                $invalidValues[] = is_object($arrayOfGeofenceBasicInformationGeofenceBasicInformationItem) ? get_class($arrayOfGeofenceBasicInformationGeofenceBasicInformationItem) : sprintf('%s(%s)', gettype($arrayOfGeofenceBasicInformationGeofenceBasicInformationItem), var_export($arrayOfGeofenceBasicInformationGeofenceBasicInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeofenceBasicInformation property can only contain items of type \StructType\GeofenceBasicInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeofenceBasicInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceBasicInformation[] $geofenceBasicInformation
     * @return \ArrayType\ArrayOfGeofenceBasicInformation
     */
    public function setGeofenceBasicInformation(array $geofenceBasicInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($geofenceBasicInformationArrayErrorMessage = self::validateGeofenceBasicInformationForArrayConstraintsFromSetGeofenceBasicInformation($geofenceBasicInformation))) {
            throw new \InvalidArgumentException($geofenceBasicInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($geofenceBasicInformation) || (is_array($geofenceBasicInformation) && empty($geofenceBasicInformation))) {
            unset($this->GeofenceBasicInformation);
        } else {
            $this->GeofenceBasicInformation = $geofenceBasicInformation;
        }
        return $this;
    }
    /**
     * Add item to GeofenceBasicInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceBasicInformation $item
     * @return \ArrayType\ArrayOfGeofenceBasicInformation
     */
    public function addToGeofenceBasicInformation(\StructType\GeofenceBasicInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeofenceBasicInformation) {
            throw new \InvalidArgumentException(sprintf('The GeofenceBasicInformation property can only contain items of type \StructType\GeofenceBasicInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeofenceBasicInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GeofenceBasicInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GeofenceBasicInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GeofenceBasicInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GeofenceBasicInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GeofenceBasicInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeofenceBasicInformation
     */
    public function getAttributeName()
    {
        return 'GeofenceBasicInformation';
    }
}
