<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tag_specs StructType
 * @subpackage Structs
 */
class Tag_specs extends AbstractStructBase
{
    /**
     * The tag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Avl_tag
     */
    public $tag;
    /**
     * The specs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfavl_spec
     */
    public $specs;
    /**
     * Constructor method for tag_specs
     * @uses Tag_specs::setTag()
     * @uses Tag_specs::setSpecs()
     * @param \StructType\Avl_tag $tag
     * @param \ArrayType\ArrayOfavl_spec $specs
     */
    public function __construct(\StructType\Avl_tag $tag = null, \ArrayType\ArrayOfavl_spec $specs = null)
    {
        $this
            ->setTag($tag)
            ->setSpecs($specs);
    }
    /**
     * Get tag value
     * @return \StructType\Avl_tag|null
     */
    public function getTag()
    {
        return $this->tag;
    }
    /**
     * Set tag value
     * @param \StructType\Avl_tag $tag
     * @return \StructType\Tag_specs
     */
    public function setTag(\StructType\Avl_tag $tag = null)
    {
        $this->tag = $tag;
        return $this;
    }
    /**
     * Get specs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfavl_spec|null
     */
    public function getSpecs()
    {
        return isset($this->specs) ? $this->specs : null;
    }
    /**
     * Set specs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfavl_spec $specs
     * @return \StructType\Tag_specs
     */
    public function setSpecs(\ArrayType\ArrayOfavl_spec $specs = null)
    {
        if (is_null($specs) || (is_array($specs) && empty($specs))) {
            unset($this->specs);
        } else {
            $this->specs = $specs;
        }
        return $this;
    }
}
