<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_RoutesResponse StructType
 * @subpackage Structs
 */
class Payments_RoutesResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The routes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayments_Route
     */
    public $routes;
    /**
     * Constructor method for Payments_RoutesResponse
     * @uses Payments_RoutesResponse::setError_code()
     * @uses Payments_RoutesResponse::setStatus()
     * @uses Payments_RoutesResponse::setDescription()
     * @uses Payments_RoutesResponse::setRoutes()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfPayments_Route $routes
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfPayments_Route $routes = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setRoutes($routes);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\Payments_RoutesResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Payments_RoutesResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Payments_RoutesResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayments_Route|null
     */
    public function getRoutes()
    {
        return isset($this->routes) ? $this->routes : null;
    }
    /**
     * Set routes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayments_Route $routes
     * @return \StructType\Payments_RoutesResponse
     */
    public function setRoutes(\ArrayType\ArrayOfPayments_Route $routes = null)
    {
        if (is_null($routes) || (is_array($routes) && empty($routes))) {
            unset($this->routes);
        } else {
            $this->routes = $routes;
        }
        return $this;
    }
}
