<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GET_GeofenceEventLogByMid StructType
 * @subpackage Structs
 */
class GET_GeofenceEventLogByMid extends AbstractStructBase
{
    /**
     * The geofenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $geofenceId;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The dateInit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateInit;
    /**
     * The dateEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateEnd;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The trackerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trackerId;
    /**
     * Constructor method for GET_GeofenceEventLogByMid
     * @uses GET_GeofenceEventLogByMid::setGeofenceId()
     * @uses GET_GeofenceEventLogByMid::setUser()
     * @uses GET_GeofenceEventLogByMid::setPassword()
     * @uses GET_GeofenceEventLogByMid::setDateInit()
     * @uses GET_GeofenceEventLogByMid::setDateEnd()
     * @uses GET_GeofenceEventLogByMid::setTimeZone()
     * @uses GET_GeofenceEventLogByMid::setTrackerId()
     * @param int $geofenceId
     * @param string $user
     * @param string $password
     * @param string $dateInit
     * @param string $dateEnd
     * @param string $timeZone
     * @param string $trackerId
     */
    public function __construct($geofenceId = null, $user = null, $password = null, $dateInit = null, $dateEnd = null, $timeZone = null, $trackerId = null)
    {
        $this
            ->setGeofenceId($geofenceId)
            ->setUser($user)
            ->setPassword($password)
            ->setDateInit($dateInit)
            ->setDateEnd($dateEnd)
            ->setTimeZone($timeZone)
            ->setTrackerId($trackerId);
    }
    /**
     * Get geofenceId value
     * @return int
     */
    public function getGeofenceId()
    {
        return $this->geofenceId;
    }
    /**
     * Set geofenceId value
     * @param int $geofenceId
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setGeofenceId($geofenceId = null)
    {
        // validation for constraint: int
        if (!is_null($geofenceId) && !(is_int($geofenceId) || ctype_digit($geofenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geofenceId, true), gettype($geofenceId)), __LINE__);
        }
        $this->geofenceId = $geofenceId;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get dateInit value
     * @return string|null
     */
    public function getDateInit()
    {
        return $this->dateInit;
    }
    /**
     * Set dateInit value
     * @param string $dateInit
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setDateInit($dateInit = null)
    {
        // validation for constraint: string
        if (!is_null($dateInit) && !is_string($dateInit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateInit, true), gettype($dateInit)), __LINE__);
        }
        $this->dateInit = $dateInit;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param string $timeZone
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get trackerId value
     * @return string|null
     */
    public function getTrackerId()
    {
        return $this->trackerId;
    }
    /**
     * Set trackerId value
     * @param string $trackerId
     * @return \StructType\GET_GeofenceEventLogByMid
     */
    public function setTrackerId($trackerId = null)
    {
        // validation for constraint: string
        if (!is_null($trackerId) && !is_string($trackerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackerId, true), gettype($trackerId)), __LINE__);
        }
        $this->trackerId = $trackerId;
        return $this;
    }
}
