<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETN ServiceType
 * @subpackage Services
 */
class GETN extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_NearestEventWhen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_NearestEventWhen $parameters
     * @return \StructType\GET_NearestEventWhenResponse|bool
     */
    public function GET_NearestEventWhen(\StructType\GET_NearestEventWhen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_NearestEventWhen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_NextItPointArrival
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_NextItPointArrival $parameters
     * @return \StructType\GET_NextItPointArrivalResponse|bool
     */
    public function GET_NextItPointArrival(\StructType\GET_NextItPointArrival $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_NextItPointArrival($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_NearestEventWhenResponse|\StructType\GET_NextItPointArrivalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
