<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETM ServiceType
 * @subpackage Services
 */
class GETM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_MobileList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileList $parameters
     * @return \StructType\GET_MobileListResponse|bool
     */
    public function GET_MobileList(\StructType\GET_MobileList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileGroups $parameters
     * @return \StructType\GET_MobileGroupsResponse|bool
     */
    public function GET_MobileGroups(\StructType\GET_MobileGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileInfo $parameters
     * @return \StructType\GET_MobileInfoResponse|bool
     */
    public function GET_MobileInfo(\StructType\GET_MobileInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileOperationInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileOperationInfo $parameters
     * @return \StructType\GET_MobileOperationInfoResponse|bool
     */
    public function GET_MobileOperationInfo(\StructType\GET_MobileOperationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileOperationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_MobileGroupsResponse|\StructType\GET_MobileInfoResponse|\StructType\GET_MobileListResponse|\StructType\GET_MobileOperationInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
