<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETG ServiceType
 * @subpackage Services
 */
class GETG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_GeolocatedPassengerHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeolocatedPassengerHistory $parameters
     * @return \StructType\GET_GeolocatedPassengerHistoryResponse|bool
     */
    public function GET_GeolocatedPassengerHistory(\StructType\GET_GeolocatedPassengerHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_GeolocatedPassengerHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_GeofenceEventLogByMid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeofenceEventLogByMid $parameters
     * @return \StructType\GET_GeofenceEventLogByMidResponse|bool
     */
    public function GET_GeofenceEventLogByMid(\StructType\GET_GeofenceEventLogByMid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_GeofenceEventLogByMid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_GeofenceEventLogByMidResponse|\StructType\GET_GeolocatedPassengerHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
