<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETF ServiceType
 * @subpackage Services
 */
class GETF extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_FleetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_FleetList $parameters
     * @return \StructType\GET_FleetListResponse|bool
     */
    public function GET_FleetList(\StructType\GET_FleetList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_FleetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_FilteredGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_FilteredGroups $parameters
     * @return \StructType\GET_FilteredGroupsResponse|bool
     */
    public function GET_FilteredGroups(\StructType\GET_FilteredGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_FilteredGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_FleetItineraries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_FleetItineraries $parameters
     * @return \StructType\GET_FleetItinerariesResponse|bool
     */
    public function GET_FleetItineraries(\StructType\GET_FleetItineraries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_FleetItineraries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_FilteredGroupsResponse|\StructType\GET_FleetItinerariesResponse|\StructType\GET_FleetListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
