<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETC ServiceType
 * @subpackage Services
 */
class GETC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_CounterHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CounterHistory $parameters
     * @return \StructType\GET_CounterHistoryResponse|bool
     */
    public function GET_CounterHistory(\StructType\GET_CounterHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CounterHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_CommandList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CommandList $parameters
     * @return \StructType\GET_CommandListResponse|bool
     */
    public function GET_CommandList(\StructType\GET_CommandList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CommandList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_CommandListResponse|\StructType\GET_CounterHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
