<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileCommand ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileCommand extends AbstractStructArrayBase
{
    /**
     * The MobileCommand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MobileCommand[]
     */
    public $MobileCommand;
    /**
     * Constructor method for ArrayOfMobileCommand
     * @uses ArrayOfMobileCommand::setMobileCommand()
     * @param \StructType\MobileCommand[] $mobileCommand
     */
    public function __construct(array $mobileCommand = array())
    {
        $this
            ->setMobileCommand($mobileCommand);
    }
    /**
     * Get MobileCommand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MobileCommand[]|null
     */
    public function getMobileCommand()
    {
        return isset($this->MobileCommand) ? $this->MobileCommand : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMobileCommand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMobileCommand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMobileCommandForArrayConstraintsFromSetMobileCommand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMobileCommandMobileCommandItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileCommandMobileCommandItem instanceof \StructType\MobileCommand) {
                $invalidValues[] = is_object($arrayOfMobileCommandMobileCommandItem) ? get_class($arrayOfMobileCommandMobileCommandItem) : sprintf('%s(%s)', gettype($arrayOfMobileCommandMobileCommandItem), var_export($arrayOfMobileCommandMobileCommandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MobileCommand property can only contain items of type \StructType\MobileCommand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MobileCommand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MobileCommand[] $mobileCommand
     * @return \ArrayType\ArrayOfMobileCommand
     */
    public function setMobileCommand(array $mobileCommand = array())
    {
        // validation for constraint: array
        if ('' !== ($mobileCommandArrayErrorMessage = self::validateMobileCommandForArrayConstraintsFromSetMobileCommand($mobileCommand))) {
            throw new \InvalidArgumentException($mobileCommandArrayErrorMessage, __LINE__);
        }
        if (is_null($mobileCommand) || (is_array($mobileCommand) && empty($mobileCommand))) {
            unset($this->MobileCommand);
        } else {
            $this->MobileCommand = $mobileCommand;
        }
        return $this;
    }
    /**
     * Add item to MobileCommand value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileCommand $item
     * @return \ArrayType\ArrayOfMobileCommand
     */
    public function addToMobileCommand(\StructType\MobileCommand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileCommand) {
            throw new \InvalidArgumentException(sprintf('The MobileCommand property can only contain items of type \StructType\MobileCommand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MobileCommand[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileCommand|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileCommand|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileCommand|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileCommand|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileCommand|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileCommand
     */
    public function getAttributeName()
    {
        return 'MobileCommand';
    }
}
