<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeofenceEventLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfGeofenceEventLog extends AbstractStructArrayBase
{
    /**
     * The GeofenceEventLog
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeofenceEventLog[]
     */
    public $GeofenceEventLog;
    /**
     * Constructor method for ArrayOfGeofenceEventLog
     * @uses ArrayOfGeofenceEventLog::setGeofenceEventLog()
     * @param \StructType\GeofenceEventLog[] $geofenceEventLog
     */
    public function __construct(array $geofenceEventLog = array())
    {
        $this
            ->setGeofenceEventLog($geofenceEventLog);
    }
    /**
     * Get GeofenceEventLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeofenceEventLog[]|null
     */
    public function getGeofenceEventLog()
    {
        return isset($this->GeofenceEventLog) ? $this->GeofenceEventLog : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGeofenceEventLog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeofenceEventLog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeofenceEventLogForArrayConstraintsFromSetGeofenceEventLog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGeofenceEventLogGeofenceEventLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeofenceEventLogGeofenceEventLogItem instanceof \StructType\GeofenceEventLog) {
                $invalidValues[] = is_object($arrayOfGeofenceEventLogGeofenceEventLogItem) ? get_class($arrayOfGeofenceEventLogGeofenceEventLogItem) : sprintf('%s(%s)', gettype($arrayOfGeofenceEventLogGeofenceEventLogItem), var_export($arrayOfGeofenceEventLogGeofenceEventLogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeofenceEventLog property can only contain items of type \StructType\GeofenceEventLog, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeofenceEventLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceEventLog[] $geofenceEventLog
     * @return \ArrayType\ArrayOfGeofenceEventLog
     */
    public function setGeofenceEventLog(array $geofenceEventLog = array())
    {
        // validation for constraint: array
        if ('' !== ($geofenceEventLogArrayErrorMessage = self::validateGeofenceEventLogForArrayConstraintsFromSetGeofenceEventLog($geofenceEventLog))) {
            throw new \InvalidArgumentException($geofenceEventLogArrayErrorMessage, __LINE__);
        }
        if (is_null($geofenceEventLog) || (is_array($geofenceEventLog) && empty($geofenceEventLog))) {
            unset($this->GeofenceEventLog);
        } else {
            $this->GeofenceEventLog = $geofenceEventLog;
        }
        return $this;
    }
    /**
     * Add item to GeofenceEventLog value
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceEventLog $item
     * @return \ArrayType\ArrayOfGeofenceEventLog
     */
    public function addToGeofenceEventLog(\StructType\GeofenceEventLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeofenceEventLog) {
            throw new \InvalidArgumentException(sprintf('The GeofenceEventLog property can only contain items of type \StructType\GeofenceEventLog, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeofenceEventLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GeofenceEventLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GeofenceEventLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GeofenceEventLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GeofenceEventLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GeofenceEventLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeofenceEventLog
     */
    public function getAttributeName()
    {
        return 'GeofenceEventLog';
    }
}
