<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventItinery ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventItinery extends AbstractStructArrayBase
{
    /**
     * The EventItinery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventItinery[]
     */
    public $EventItinery;
    /**
     * Constructor method for ArrayOfEventItinery
     * @uses ArrayOfEventItinery::setEventItinery()
     * @param \StructType\EventItinery[] $eventItinery
     */
    public function __construct(array $eventItinery = array())
    {
        $this
            ->setEventItinery($eventItinery);
    }
    /**
     * Get EventItinery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventItinery[]|null
     */
    public function getEventItinery()
    {
        return isset($this->EventItinery) ? $this->EventItinery : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventItinery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventItinery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventItineryForArrayConstraintsFromSetEventItinery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventItineryEventItineryItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventItineryEventItineryItem instanceof \StructType\EventItinery) {
                $invalidValues[] = is_object($arrayOfEventItineryEventItineryItem) ? get_class($arrayOfEventItineryEventItineryItem) : sprintf('%s(%s)', gettype($arrayOfEventItineryEventItineryItem), var_export($arrayOfEventItineryEventItineryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventItinery property can only contain items of type \StructType\EventItinery, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventItinery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventItinery[] $eventItinery
     * @return \ArrayType\ArrayOfEventItinery
     */
    public function setEventItinery(array $eventItinery = array())
    {
        // validation for constraint: array
        if ('' !== ($eventItineryArrayErrorMessage = self::validateEventItineryForArrayConstraintsFromSetEventItinery($eventItinery))) {
            throw new \InvalidArgumentException($eventItineryArrayErrorMessage, __LINE__);
        }
        if (is_null($eventItinery) || (is_array($eventItinery) && empty($eventItinery))) {
            unset($this->EventItinery);
        } else {
            $this->EventItinery = $eventItinery;
        }
        return $this;
    }
    /**
     * Add item to EventItinery value
     * @throws \InvalidArgumentException
     * @param \StructType\EventItinery $item
     * @return \ArrayType\ArrayOfEventItinery
     */
    public function addToEventItinery(\StructType\EventItinery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventItinery) {
            throw new \InvalidArgumentException(sprintf('The EventItinery property can only contain items of type \StructType\EventItinery, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventItinery[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventItinery|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventItinery|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventItinery|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventItinery|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventItinery|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventItinery
     */
    public function getAttributeName()
    {
        return 'EventItinery';
    }
}
