<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCANEventLocation ArrayType
 * @subpackage Arrays
 */
class ArrayOfCANEventLocation extends AbstractStructArrayBase
{
    /**
     * The CANEventLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CANEventLocation[]
     */
    public $CANEventLocation;
    /**
     * Constructor method for ArrayOfCANEventLocation
     * @uses ArrayOfCANEventLocation::setCANEventLocation()
     * @param \StructType\CANEventLocation[] $cANEventLocation
     */
    public function __construct(array $cANEventLocation = array())
    {
        $this
            ->setCANEventLocation($cANEventLocation);
    }
    /**
     * Get CANEventLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CANEventLocation[]|null
     */
    public function getCANEventLocation()
    {
        return isset($this->CANEventLocation) ? $this->CANEventLocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCANEventLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCANEventLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCANEventLocationForArrayConstraintsFromSetCANEventLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCANEventLocationCANEventLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfCANEventLocationCANEventLocationItem instanceof \StructType\CANEventLocation) {
                $invalidValues[] = is_object($arrayOfCANEventLocationCANEventLocationItem) ? get_class($arrayOfCANEventLocationCANEventLocationItem) : sprintf('%s(%s)', gettype($arrayOfCANEventLocationCANEventLocationItem), var_export($arrayOfCANEventLocationCANEventLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CANEventLocation property can only contain items of type \StructType\CANEventLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CANEventLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CANEventLocation[] $cANEventLocation
     * @return \ArrayType\ArrayOfCANEventLocation
     */
    public function setCANEventLocation(array $cANEventLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($cANEventLocationArrayErrorMessage = self::validateCANEventLocationForArrayConstraintsFromSetCANEventLocation($cANEventLocation))) {
            throw new \InvalidArgumentException($cANEventLocationArrayErrorMessage, __LINE__);
        }
        if (is_null($cANEventLocation) || (is_array($cANEventLocation) && empty($cANEventLocation))) {
            unset($this->CANEventLocation);
        } else {
            $this->CANEventLocation = $cANEventLocation;
        }
        return $this;
    }
    /**
     * Add item to CANEventLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\CANEventLocation $item
     * @return \ArrayType\ArrayOfCANEventLocation
     */
    public function addToCANEventLocation(\StructType\CANEventLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CANEventLocation) {
            throw new \InvalidArgumentException(sprintf('The CANEventLocation property can only contain items of type \StructType\CANEventLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CANEventLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CANEventLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CANEventLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CANEventLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CANEventLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CANEventLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CANEventLocation
     */
    public function getAttributeName()
    {
        return 'CANEventLocation';
    }
}
