<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAlert ArrayType
 * @subpackage Arrays
 */
class ArrayOfAlert extends AbstractStructArrayBase
{
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Alert[]
     */
    public $Alert;
    /**
     * Constructor method for ArrayOfAlert
     * @uses ArrayOfAlert::setAlert()
     * @param \StructType\Alert[] $alert
     */
    public function __construct(array $alert = array())
    {
        $this
            ->setAlert($alert);
    }
    /**
     * Get Alert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Alert[]|null
     */
    public function getAlert()
    {
        return isset($this->Alert) ? $this->Alert : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAlertAlertItem) {
            // validation for constraint: itemType
            if (!$arrayOfAlertAlertItem instanceof \StructType\Alert) {
                $invalidValues[] = is_object($arrayOfAlertAlertItem) ? get_class($arrayOfAlertAlertItem) : sprintf('%s(%s)', gettype($arrayOfAlertAlertItem), var_export($arrayOfAlertAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \StructType\Alert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Alert[] $alert
     * @return \ArrayType\ArrayOfAlert
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        if (is_null($alert) || (is_array($alert) && empty($alert))) {
            unset($this->Alert);
        } else {
            $this->Alert = $alert;
        }
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \StructType\Alert $item
     * @return \ArrayType\ArrayOfAlert
     */
    public function addToAlert(\StructType\Alert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alert) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \StructType\Alert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Alert|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Alert|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Alert|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Alert|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Alert|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Alert
     */
    public function getAttributeName()
    {
        return 'Alert';
    }
}
