<?php

namespace ColissimoPickupPoint\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DropOffPoint StructType
 * @subpackage Structs
 */
class DropOffPoint extends AbstractStructBase
{
    /**
     * The accessibleForReducedMobility
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $accessibleForReducedMobility;
    /**
     * The addressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine1;
    /**
     * The addressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine2;
    /**
     * The addressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLine3;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The countryLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryLabel;
    /**
     * The displayLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayLanguage;
    /**
     * The distanceInMeters
     * @var int
     */
    public $distanceInMeters;
    /**
     * The distributionNetwork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $distributionNetwork;
    /**
     * The geoLatitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geoLatitude;
    /**
     * The geoLongitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geoLongitude;
    /**
     * The holidaysList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ColissimoPickupPoint\StructType\Conges[]
     */
    public $holidaysList;
    /**
     * The loanOfHandlingTool
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $loanOfHandlingTool;
    /**
     * The maxWeight
     * @var int
     */
    public $maxWeight;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The openingHoursFriday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursFriday;
    /**
     * The openingHoursMonday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursMonday;
    /**
     * The openingHoursSaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursSaturday;
    /**
     * The openingHoursSunday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursSunday;
    /**
     * The openingHoursThursday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursThursday;
    /**
     * The openingHoursTuesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursTuesday;
    /**
     * The openingHoursWednesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingHoursWednesday;
    /**
     * The parking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $parking;
    /**
     * The partialClosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $partialClosure;
    /**
     * The pointId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pointId;
    /**
     * The pointType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pointType;
    /**
     * The schedulePeriodEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schedulePeriodEnd;
    /**
     * The schedulePeriodStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schedulePeriodStart;
    /**
     * The serviceDepotType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $serviceDepotType;
    /**
     * The totalClosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $totalClosure;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * Constructor method for DropOffPoint
     * @uses DropOffPoint::setAccessibleForReducedMobility()
     * @uses DropOffPoint::setAddressLine1()
     * @uses DropOffPoint::setAddressLine2()
     * @uses DropOffPoint::setAddressLine3()
     * @uses DropOffPoint::setCity()
     * @uses DropOffPoint::setCountryCode()
     * @uses DropOffPoint::setCountryLabel()
     * @uses DropOffPoint::setDisplayLanguage()
     * @uses DropOffPoint::setDistanceInMeters()
     * @uses DropOffPoint::setDistributionNetwork()
     * @uses DropOffPoint::setGeoLatitude()
     * @uses DropOffPoint::setGeoLongitude()
     * @uses DropOffPoint::setHolidaysList()
     * @uses DropOffPoint::setLoanOfHandlingTool()
     * @uses DropOffPoint::setMaxWeight()
     * @uses DropOffPoint::setName()
     * @uses DropOffPoint::setOpeningHoursFriday()
     * @uses DropOffPoint::setOpeningHoursMonday()
     * @uses DropOffPoint::setOpeningHoursSaturday()
     * @uses DropOffPoint::setOpeningHoursSunday()
     * @uses DropOffPoint::setOpeningHoursThursday()
     * @uses DropOffPoint::setOpeningHoursTuesday()
     * @uses DropOffPoint::setOpeningHoursWednesday()
     * @uses DropOffPoint::setParking()
     * @uses DropOffPoint::setPartialClosure()
     * @uses DropOffPoint::setPointId()
     * @uses DropOffPoint::setPointType()
     * @uses DropOffPoint::setSchedulePeriodEnd()
     * @uses DropOffPoint::setSchedulePeriodStart()
     * @uses DropOffPoint::setServiceDepotType()
     * @uses DropOffPoint::setTotalClosure()
     * @uses DropOffPoint::setZipCode()
     * @param bool $accessibleForReducedMobility
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $city
     * @param string $countryCode
     * @param string $countryLabel
     * @param string $displayLanguage
     * @param int $distanceInMeters
     * @param string $distributionNetwork
     * @param string $geoLatitude
     * @param string $geoLongitude
     * @param \ColissimoPickupPoint\StructType\Conges[] $holidaysList
     * @param bool $loanOfHandlingTool
     * @param int $maxWeight
     * @param string $name
     * @param string $openingHoursFriday
     * @param string $openingHoursMonday
     * @param string $openingHoursSaturday
     * @param string $openingHoursSunday
     * @param string $openingHoursThursday
     * @param string $openingHoursTuesday
     * @param string $openingHoursWednesday
     * @param bool $parking
     * @param bool $partialClosure
     * @param string $pointId
     * @param string $pointType
     * @param string $schedulePeriodEnd
     * @param string $schedulePeriodStart
     * @param string[] $serviceDepotType
     * @param bool $totalClosure
     * @param string $zipCode
     */
    public function __construct($accessibleForReducedMobility = null, $addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $city = null, $countryCode = null, $countryLabel = null, $displayLanguage = null, $distanceInMeters = null, $distributionNetwork = null, $geoLatitude = null, $geoLongitude = null, array $holidaysList = array(), $loanOfHandlingTool = null, $maxWeight = null, $name = null, $openingHoursFriday = null, $openingHoursMonday = null, $openingHoursSaturday = null, $openingHoursSunday = null, $openingHoursThursday = null, $openingHoursTuesday = null, $openingHoursWednesday = null, $parking = null, $partialClosure = null, $pointId = null, $pointType = null, $schedulePeriodEnd = null, $schedulePeriodStart = null, array $serviceDepotType = array(), $totalClosure = null, $zipCode = null)
    {
        $this
            ->setAccessibleForReducedMobility($accessibleForReducedMobility)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setCountryLabel($countryLabel)
            ->setDisplayLanguage($displayLanguage)
            ->setDistanceInMeters($distanceInMeters)
            ->setDistributionNetwork($distributionNetwork)
            ->setGeoLatitude($geoLatitude)
            ->setGeoLongitude($geoLongitude)
            ->setHolidaysList($holidaysList)
            ->setLoanOfHandlingTool($loanOfHandlingTool)
            ->setMaxWeight($maxWeight)
            ->setName($name)
            ->setOpeningHoursFriday($openingHoursFriday)
            ->setOpeningHoursMonday($openingHoursMonday)
            ->setOpeningHoursSaturday($openingHoursSaturday)
            ->setOpeningHoursSunday($openingHoursSunday)
            ->setOpeningHoursThursday($openingHoursThursday)
            ->setOpeningHoursTuesday($openingHoursTuesday)
            ->setOpeningHoursWednesday($openingHoursWednesday)
            ->setParking($parking)
            ->setPartialClosure($partialClosure)
            ->setPointId($pointId)
            ->setPointType($pointType)
            ->setSchedulePeriodEnd($schedulePeriodEnd)
            ->setSchedulePeriodStart($schedulePeriodStart)
            ->setServiceDepotType($serviceDepotType)
            ->setTotalClosure($totalClosure)
            ->setZipCode($zipCode);
    }
    /**
     * Get accessibleForReducedMobility value
     * @return bool|null
     */
    public function getAccessibleForReducedMobility()
    {
        return $this->accessibleForReducedMobility;
    }
    /**
     * Set accessibleForReducedMobility value
     * @param bool $accessibleForReducedMobility
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setAccessibleForReducedMobility($accessibleForReducedMobility = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessibleForReducedMobility) && !is_bool($accessibleForReducedMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessibleForReducedMobility, true), gettype($accessibleForReducedMobility)), __LINE__);
        }
        $this->accessibleForReducedMobility = $accessibleForReducedMobility;
        return $this;
    }
    /**
     * Get addressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }
    /**
     * Set addressLine1 value
     * @param string $addressLine1
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->addressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get addressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }
    /**
     * Set addressLine2 value
     * @param string $addressLine2
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->addressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get addressLine3 value
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->addressLine3;
    }
    /**
     * Set addressLine3 value
     * @param string $addressLine3
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        $this->addressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get countryLabel value
     * @return string|null
     */
    public function getCountryLabel()
    {
        return $this->countryLabel;
    }
    /**
     * Set countryLabel value
     * @param string $countryLabel
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setCountryLabel($countryLabel = null)
    {
        // validation for constraint: string
        if (!is_null($countryLabel) && !is_string($countryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryLabel, true), gettype($countryLabel)), __LINE__);
        }
        $this->countryLabel = $countryLabel;
        return $this;
    }
    /**
     * Get displayLanguage value
     * @return string|null
     */
    public function getDisplayLanguage()
    {
        return $this->displayLanguage;
    }
    /**
     * Set displayLanguage value
     * @param string $displayLanguage
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setDisplayLanguage($displayLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($displayLanguage) && !is_string($displayLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayLanguage, true), gettype($displayLanguage)), __LINE__);
        }
        $this->displayLanguage = $displayLanguage;
        return $this;
    }
    /**
     * Get distanceInMeters value
     * @return int|null
     */
    public function getDistanceInMeters()
    {
        return $this->distanceInMeters;
    }
    /**
     * Set distanceInMeters value
     * @param int $distanceInMeters
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setDistanceInMeters($distanceInMeters = null)
    {
        // validation for constraint: int
        if (!is_null($distanceInMeters) && !(is_int($distanceInMeters) || ctype_digit($distanceInMeters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distanceInMeters, true), gettype($distanceInMeters)), __LINE__);
        }
        $this->distanceInMeters = $distanceInMeters;
        return $this;
    }
    /**
     * Get distributionNetwork value
     * @return string|null
     */
    public function getDistributionNetwork()
    {
        return $this->distributionNetwork;
    }
    /**
     * Set distributionNetwork value
     * @param string $distributionNetwork
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setDistributionNetwork($distributionNetwork = null)
    {
        // validation for constraint: string
        if (!is_null($distributionNetwork) && !is_string($distributionNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionNetwork, true), gettype($distributionNetwork)), __LINE__);
        }
        $this->distributionNetwork = $distributionNetwork;
        return $this;
    }
    /**
     * Get geoLatitude value
     * @return string|null
     */
    public function getGeoLatitude()
    {
        return $this->geoLatitude;
    }
    /**
     * Set geoLatitude value
     * @param string $geoLatitude
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setGeoLatitude($geoLatitude = null)
    {
        // validation for constraint: string
        if (!is_null($geoLatitude) && !is_string($geoLatitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoLatitude, true), gettype($geoLatitude)), __LINE__);
        }
        $this->geoLatitude = $geoLatitude;
        return $this;
    }
    /**
     * Get geoLongitude value
     * @return string|null
     */
    public function getGeoLongitude()
    {
        return $this->geoLongitude;
    }
    /**
     * Set geoLongitude value
     * @param string $geoLongitude
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setGeoLongitude($geoLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($geoLongitude) && !is_string($geoLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoLongitude, true), gettype($geoLongitude)), __LINE__);
        }
        $this->geoLongitude = $geoLongitude;
        return $this;
    }
    /**
     * Get holidaysList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ColissimoPickupPoint\StructType\Conges[]|null
     */
    public function getHolidaysList()
    {
        return isset($this->holidaysList) ? $this->holidaysList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHolidaysList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHolidaysList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHolidaysListForArrayConstraintsFromSetHolidaysList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dropOffPointHolidaysListItem) {
            // validation for constraint: itemType
            if (!$dropOffPointHolidaysListItem instanceof \ColissimoPickupPoint\StructType\Conges) {
                $invalidValues[] = is_object($dropOffPointHolidaysListItem) ? get_class($dropOffPointHolidaysListItem) : sprintf('%s(%s)', gettype($dropOffPointHolidaysListItem), var_export($dropOffPointHolidaysListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The holidaysList property can only contain items of type \ColissimoPickupPoint\StructType\Conges, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set holidaysList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ColissimoPickupPoint\StructType\Conges[] $holidaysList
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setHolidaysList(array $holidaysList = array())
    {
        // validation for constraint: array
        if ('' !== ($holidaysListArrayErrorMessage = self::validateHolidaysListForArrayConstraintsFromSetHolidaysList($holidaysList))) {
            throw new \InvalidArgumentException($holidaysListArrayErrorMessage, __LINE__);
        }
        if (is_null($holidaysList) || (is_array($holidaysList) && empty($holidaysList))) {
            unset($this->holidaysList);
        } else {
            $this->holidaysList = $holidaysList;
        }
        return $this;
    }
    /**
     * Add item to holidaysList value
     * @throws \InvalidArgumentException
     * @param \ColissimoPickupPoint\StructType\Conges $item
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function addToHolidaysList(\ColissimoPickupPoint\StructType\Conges $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ColissimoPickupPoint\StructType\Conges) {
            throw new \InvalidArgumentException(sprintf('The holidaysList property can only contain items of type \ColissimoPickupPoint\StructType\Conges, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->holidaysList[] = $item;
        return $this;
    }
    /**
     * Get loanOfHandlingTool value
     * @return bool|null
     */
    public function getLoanOfHandlingTool()
    {
        return $this->loanOfHandlingTool;
    }
    /**
     * Set loanOfHandlingTool value
     * @param bool $loanOfHandlingTool
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setLoanOfHandlingTool($loanOfHandlingTool = null)
    {
        // validation for constraint: boolean
        if (!is_null($loanOfHandlingTool) && !is_bool($loanOfHandlingTool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loanOfHandlingTool, true), gettype($loanOfHandlingTool)), __LINE__);
        }
        $this->loanOfHandlingTool = $loanOfHandlingTool;
        return $this;
    }
    /**
     * Get maxWeight value
     * @return int|null
     */
    public function getMaxWeight()
    {
        return $this->maxWeight;
    }
    /**
     * Set maxWeight value
     * @param int $maxWeight
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setMaxWeight($maxWeight = null)
    {
        // validation for constraint: int
        if (!is_null($maxWeight) && !(is_int($maxWeight) || ctype_digit($maxWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxWeight, true), gettype($maxWeight)), __LINE__);
        }
        $this->maxWeight = $maxWeight;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get openingHoursFriday value
     * @return string|null
     */
    public function getOpeningHoursFriday()
    {
        return $this->openingHoursFriday;
    }
    /**
     * Set openingHoursFriday value
     * @param string $openingHoursFriday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursFriday($openingHoursFriday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursFriday) && !is_string($openingHoursFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursFriday, true), gettype($openingHoursFriday)), __LINE__);
        }
        $this->openingHoursFriday = $openingHoursFriday;
        return $this;
    }
    /**
     * Get openingHoursMonday value
     * @return string|null
     */
    public function getOpeningHoursMonday()
    {
        return $this->openingHoursMonday;
    }
    /**
     * Set openingHoursMonday value
     * @param string $openingHoursMonday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursMonday($openingHoursMonday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursMonday) && !is_string($openingHoursMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursMonday, true), gettype($openingHoursMonday)), __LINE__);
        }
        $this->openingHoursMonday = $openingHoursMonday;
        return $this;
    }
    /**
     * Get openingHoursSaturday value
     * @return string|null
     */
    public function getOpeningHoursSaturday()
    {
        return $this->openingHoursSaturday;
    }
    /**
     * Set openingHoursSaturday value
     * @param string $openingHoursSaturday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursSaturday($openingHoursSaturday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursSaturday) && !is_string($openingHoursSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursSaturday, true), gettype($openingHoursSaturday)), __LINE__);
        }
        $this->openingHoursSaturday = $openingHoursSaturday;
        return $this;
    }
    /**
     * Get openingHoursSunday value
     * @return string|null
     */
    public function getOpeningHoursSunday()
    {
        return $this->openingHoursSunday;
    }
    /**
     * Set openingHoursSunday value
     * @param string $openingHoursSunday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursSunday($openingHoursSunday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursSunday) && !is_string($openingHoursSunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursSunday, true), gettype($openingHoursSunday)), __LINE__);
        }
        $this->openingHoursSunday = $openingHoursSunday;
        return $this;
    }
    /**
     * Get openingHoursThursday value
     * @return string|null
     */
    public function getOpeningHoursThursday()
    {
        return $this->openingHoursThursday;
    }
    /**
     * Set openingHoursThursday value
     * @param string $openingHoursThursday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursThursday($openingHoursThursday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursThursday) && !is_string($openingHoursThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursThursday, true), gettype($openingHoursThursday)), __LINE__);
        }
        $this->openingHoursThursday = $openingHoursThursday;
        return $this;
    }
    /**
     * Get openingHoursTuesday value
     * @return string|null
     */
    public function getOpeningHoursTuesday()
    {
        return $this->openingHoursTuesday;
    }
    /**
     * Set openingHoursTuesday value
     * @param string $openingHoursTuesday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursTuesday($openingHoursTuesday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursTuesday) && !is_string($openingHoursTuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursTuesday, true), gettype($openingHoursTuesday)), __LINE__);
        }
        $this->openingHoursTuesday = $openingHoursTuesday;
        return $this;
    }
    /**
     * Get openingHoursWednesday value
     * @return string|null
     */
    public function getOpeningHoursWednesday()
    {
        return $this->openingHoursWednesday;
    }
    /**
     * Set openingHoursWednesday value
     * @param string $openingHoursWednesday
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setOpeningHoursWednesday($openingHoursWednesday = null)
    {
        // validation for constraint: string
        if (!is_null($openingHoursWednesday) && !is_string($openingHoursWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHoursWednesday, true), gettype($openingHoursWednesday)), __LINE__);
        }
        $this->openingHoursWednesday = $openingHoursWednesday;
        return $this;
    }
    /**
     * Get parking value
     * @return bool|null
     */
    public function getParking()
    {
        return $this->parking;
    }
    /**
     * Set parking value
     * @param bool $parking
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setParking($parking = null)
    {
        // validation for constraint: boolean
        if (!is_null($parking) && !is_bool($parking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parking, true), gettype($parking)), __LINE__);
        }
        $this->parking = $parking;
        return $this;
    }
    /**
     * Get partialClosure value
     * @return bool|null
     */
    public function getPartialClosure()
    {
        return $this->partialClosure;
    }
    /**
     * Set partialClosure value
     * @param bool $partialClosure
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setPartialClosure($partialClosure = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialClosure) && !is_bool($partialClosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partialClosure, true), gettype($partialClosure)), __LINE__);
        }
        $this->partialClosure = $partialClosure;
        return $this;
    }
    /**
     * Get pointId value
     * @return string|null
     */
    public function getPointId()
    {
        return $this->pointId;
    }
    /**
     * Set pointId value
     * @param string $pointId
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setPointId($pointId = null)
    {
        // validation for constraint: string
        if (!is_null($pointId) && !is_string($pointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointId, true), gettype($pointId)), __LINE__);
        }
        $this->pointId = $pointId;
        return $this;
    }
    /**
     * Get pointType value
     * @return string|null
     */
    public function getPointType()
    {
        return $this->pointType;
    }
    /**
     * Set pointType value
     * @param string $pointType
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setPointType($pointType = null)
    {
        // validation for constraint: string
        if (!is_null($pointType) && !is_string($pointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointType, true), gettype($pointType)), __LINE__);
        }
        $this->pointType = $pointType;
        return $this;
    }
    /**
     * Get schedulePeriodEnd value
     * @return string|null
     */
    public function getSchedulePeriodEnd()
    {
        return $this->schedulePeriodEnd;
    }
    /**
     * Set schedulePeriodEnd value
     * @param string $schedulePeriodEnd
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setSchedulePeriodEnd($schedulePeriodEnd = null)
    {
        // validation for constraint: string
        if (!is_null($schedulePeriodEnd) && !is_string($schedulePeriodEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulePeriodEnd, true), gettype($schedulePeriodEnd)), __LINE__);
        }
        $this->schedulePeriodEnd = $schedulePeriodEnd;
        return $this;
    }
    /**
     * Get schedulePeriodStart value
     * @return string|null
     */
    public function getSchedulePeriodStart()
    {
        return $this->schedulePeriodStart;
    }
    /**
     * Set schedulePeriodStart value
     * @param string $schedulePeriodStart
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setSchedulePeriodStart($schedulePeriodStart = null)
    {
        // validation for constraint: string
        if (!is_null($schedulePeriodStart) && !is_string($schedulePeriodStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulePeriodStart, true), gettype($schedulePeriodStart)), __LINE__);
        }
        $this->schedulePeriodStart = $schedulePeriodStart;
        return $this;
    }
    /**
     * Get serviceDepotType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getServiceDepotType()
    {
        return isset($this->serviceDepotType) ? $this->serviceDepotType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceDepotType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDepotType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceDepotTypeForArrayConstraintsFromSetServiceDepotType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dropOffPointServiceDepotTypeItem) {
            // validation for constraint: itemType
            if (!is_string($dropOffPointServiceDepotTypeItem)) {
                $invalidValues[] = is_object($dropOffPointServiceDepotTypeItem) ? get_class($dropOffPointServiceDepotTypeItem) : sprintf('%s(%s)', gettype($dropOffPointServiceDepotTypeItem), var_export($dropOffPointServiceDepotTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serviceDepotType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serviceDepotType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $serviceDepotType
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setServiceDepotType(array $serviceDepotType = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceDepotTypeArrayErrorMessage = self::validateServiceDepotTypeForArrayConstraintsFromSetServiceDepotType($serviceDepotType))) {
            throw new \InvalidArgumentException($serviceDepotTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceDepotType) || (is_array($serviceDepotType) && empty($serviceDepotType))) {
            unset($this->serviceDepotType);
        } else {
            $this->serviceDepotType = $serviceDepotType;
        }
        return $this;
    }
    /**
     * Add item to serviceDepotType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function addToServiceDepotType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The serviceDepotType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serviceDepotType[] = $item;
        return $this;
    }
    /**
     * Get totalClosure value
     * @return bool|null
     */
    public function getTotalClosure()
    {
        return $this->totalClosure;
    }
    /**
     * Set totalClosure value
     * @param bool $totalClosure
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setTotalClosure($totalClosure = null)
    {
        // validation for constraint: boolean
        if (!is_null($totalClosure) && !is_bool($totalClosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($totalClosure, true), gettype($totalClosure)), __LINE__);
        }
        $this->totalClosure = $totalClosure;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \ColissimoPickupPoint\StructType\DropOffPoint
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
}
