<?php

namespace ColissimoPickupPoint\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findDropOffPoint StructType
 * Meta information extracted from the WSDL
 * - type: tns:findDropOffPoint
 * @subpackage Structs
 */
class FindDropOffPoint extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The apikey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apikey;
    /**
     * The clientCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $clientCode;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The returnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $returnDate;
    /**
     * The typeDropOffPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeDropOffPoint;
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestId;
    /**
     * The origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $origin;
    /**
     * Constructor method for findDropOffPoint
     * @uses FindDropOffPoint::setAccountNumber()
     * @uses FindDropOffPoint::setPassword()
     * @uses FindDropOffPoint::setApikey()
     * @uses FindDropOffPoint::setClientCode()
     * @uses FindDropOffPoint::setAddress()
     * @uses FindDropOffPoint::setZipCode()
     * @uses FindDropOffPoint::setCity()
     * @uses FindDropOffPoint::setCountryCode()
     * @uses FindDropOffPoint::setWeight()
     * @uses FindDropOffPoint::setReturnDate()
     * @uses FindDropOffPoint::setTypeDropOffPoint()
     * @uses FindDropOffPoint::setRequestId()
     * @uses FindDropOffPoint::setOrigin()
     * @param string $accountNumber
     * @param string $password
     * @param string $apikey
     * @param string $clientCode
     * @param string $address
     * @param string $zipCode
     * @param string $city
     * @param string $countryCode
     * @param string $weight
     * @param string $returnDate
     * @param string $typeDropOffPoint
     * @param string $requestId
     * @param string $origin
     */
    public function __construct($accountNumber = null, $password = null, $apikey = null, $clientCode = null, $address = null, $zipCode = null, $city = null, $countryCode = null, $weight = null, $returnDate = null, $typeDropOffPoint = null, $requestId = null, $origin = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setPassword($password)
            ->setApikey($apikey)
            ->setClientCode($clientCode)
            ->setAddress($address)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setWeight($weight)
            ->setReturnDate($returnDate)
            ->setTypeDropOffPoint($typeDropOffPoint)
            ->setRequestId($requestId)
            ->setOrigin($origin);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get apikey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApikey()
    {
        return isset($this->apikey) ? $this->apikey : null;
    }
    /**
     * Set apikey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apikey
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setApikey($apikey = null)
    {
        // validation for constraint: string
        if (!is_null($apikey) && !is_string($apikey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apikey, true), gettype($apikey)), __LINE__);
        }
        if (is_null($apikey) || (is_array($apikey) && empty($apikey))) {
            unset($this->apikey);
        } else {
            $this->apikey = $apikey;
        }
        return $this;
    }
    /**
     * Get clientCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCode()
    {
        return isset($this->clientCode) ? $this->clientCode : null;
    }
    /**
     * Set clientCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCode
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        if (is_null($clientCode) || (is_array($clientCode) && empty($clientCode))) {
            unset($this->clientCode);
        } else {
            $this->clientCode = $clientCode;
        }
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get returnDate value
     * @return string|null
     */
    public function getReturnDate()
    {
        return $this->returnDate;
    }
    /**
     * Set returnDate value
     * @param string $returnDate
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setReturnDate($returnDate = null)
    {
        // validation for constraint: string
        if (!is_null($returnDate) && !is_string($returnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDate, true), gettype($returnDate)), __LINE__);
        }
        $this->returnDate = $returnDate;
        return $this;
    }
    /**
     * Get typeDropOffPoint value
     * @return string|null
     */
    public function getTypeDropOffPoint()
    {
        return $this->typeDropOffPoint;
    }
    /**
     * Set typeDropOffPoint value
     * @param string $typeDropOffPoint
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setTypeDropOffPoint($typeDropOffPoint = null)
    {
        // validation for constraint: string
        if (!is_null($typeDropOffPoint) && !is_string($typeDropOffPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDropOffPoint, true), gettype($typeDropOffPoint)), __LINE__);
        }
        $this->typeDropOffPoint = $typeDropOffPoint;
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->origin) ? $this->origin : null;
    }
    /**
     * Set origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \ColissimoPickupPoint\StructType\FindDropOffPoint
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->origin);
        } else {
            $this->origin = $origin;
        }
        return $this;
    }
}
