<?php

namespace ColissimoPickupPoint\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dropOffPointResult StructType
 * @subpackage Structs
 */
class DropOffPointResult extends AbstractStructBase
{
    /**
     * The errorCode
     * @var int
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The listDropOffPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ColissimoPickupPoint\StructType\DropOffPoint[]
     */
    public $listDropOffPoint;
    /**
     * The qualityReponse
     * @var int
     */
    public $qualityReponse;
    /**
     * The wsRequestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsRequestId;
    /**
     * Constructor method for dropOffPointResult
     * @uses DropOffPointResult::setErrorCode()
     * @uses DropOffPointResult::setErrorMessage()
     * @uses DropOffPointResult::setListDropOffPoint()
     * @uses DropOffPointResult::setQualityReponse()
     * @uses DropOffPointResult::setWsRequestId()
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ColissimoPickupPoint\StructType\DropOffPoint[] $listDropOffPoint
     * @param int $qualityReponse
     * @param string $wsRequestId
     */
    public function __construct($errorCode = null, $errorMessage = null, array $listDropOffPoint = array(), $qualityReponse = null, $wsRequestId = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setListDropOffPoint($listDropOffPoint)
            ->setQualityReponse($qualityReponse)
            ->setWsRequestId($wsRequestId);
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get listDropOffPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ColissimoPickupPoint\StructType\DropOffPoint[]|null
     */
    public function getListDropOffPoint()
    {
        return isset($this->listDropOffPoint) ? $this->listDropOffPoint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListDropOffPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListDropOffPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListDropOffPointForArrayConstraintsFromSetListDropOffPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dropOffPointResultListDropOffPointItem) {
            // validation for constraint: itemType
            if (!$dropOffPointResultListDropOffPointItem instanceof \ColissimoPickupPoint\StructType\DropOffPoint) {
                $invalidValues[] = is_object($dropOffPointResultListDropOffPointItem) ? get_class($dropOffPointResultListDropOffPointItem) : sprintf('%s(%s)', gettype($dropOffPointResultListDropOffPointItem), var_export($dropOffPointResultListDropOffPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listDropOffPoint property can only contain items of type \ColissimoPickupPoint\StructType\DropOffPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listDropOffPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ColissimoPickupPoint\StructType\DropOffPoint[] $listDropOffPoint
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function setListDropOffPoint(array $listDropOffPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($listDropOffPointArrayErrorMessage = self::validateListDropOffPointForArrayConstraintsFromSetListDropOffPoint($listDropOffPoint))) {
            throw new \InvalidArgumentException($listDropOffPointArrayErrorMessage, __LINE__);
        }
        if (is_null($listDropOffPoint) || (is_array($listDropOffPoint) && empty($listDropOffPoint))) {
            unset($this->listDropOffPoint);
        } else {
            $this->listDropOffPoint = $listDropOffPoint;
        }
        return $this;
    }
    /**
     * Add item to listDropOffPoint value
     * @throws \InvalidArgumentException
     * @param \ColissimoPickupPoint\StructType\DropOffPoint $item
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function addToListDropOffPoint(\ColissimoPickupPoint\StructType\DropOffPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ColissimoPickupPoint\StructType\DropOffPoint) {
            throw new \InvalidArgumentException(sprintf('The listDropOffPoint property can only contain items of type \ColissimoPickupPoint\StructType\DropOffPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listDropOffPoint[] = $item;
        return $this;
    }
    /**
     * Get qualityReponse value
     * @return int|null
     */
    public function getQualityReponse()
    {
        return $this->qualityReponse;
    }
    /**
     * Set qualityReponse value
     * @param int $qualityReponse
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function setQualityReponse($qualityReponse = null)
    {
        // validation for constraint: int
        if (!is_null($qualityReponse) && !(is_int($qualityReponse) || ctype_digit($qualityReponse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qualityReponse, true), gettype($qualityReponse)), __LINE__);
        }
        $this->qualityReponse = $qualityReponse;
        return $this;
    }
    /**
     * Get wsRequestId value
     * @return string|null
     */
    public function getWsRequestId()
    {
        return $this->wsRequestId;
    }
    /**
     * Set wsRequestId value
     * @param string $wsRequestId
     * @return \ColissimoPickupPoint\StructType\DropOffPointResult
     */
    public function setWsRequestId($wsRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($wsRequestId) && !is_string($wsRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsRequestId, true), gettype($wsRequestId)), __LINE__);
        }
        $this->wsRequestId = $wsRequestId;
        return $this;
    }
}
